% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\name{seedset-class}
\alias{seedset-class}
\title{\code{seedset-class}}
\description{
Object representing the seed sets of a given metabolic network
}
\section{Slots}{

\describe{
\item{\code{GsMN,}}{a igraph network}

\item{\code{seeds,}}{a character list represents seeds of a given metabolic 
network which is composed of  the KEGG compound index.}
}}
\section{method}{

   \itemize{
     \item{getGsMN, \code{signature(object = "seedset")}:
       get the genome scale metabolic network whose seed set is caculated}
     \item{len, \code{signature(object = "seedset")}:
       return the number of source SCC}
     \item{seedSize, \code{signature(object = "seedset")}:
       returns the sizes of each source SCCs}
     \item{nonseed, \code{signature(object = "seedset")}:
       the non seeds of the GsMN}
     \item{show, \code{signature(object = "seedset")}:
       show the short summary of a seedset class}
     \item{confidencescore, \code{signature(object = "seedset")}:
       confidence score of the seed set}
 }
}
\examples{
\dontrun{
#' ## generate a metabolic network in igraph class and a seed set of this graph
annodir <- system.file("extdata","koanno.tab",package = "RevEcoR")
metabolic.data <- read.delim2(file=annodir,stringsAsFactors=FALSE)
g <- reconstructGsMN(metabolic.data)
seeds <- getSeedSets(g)@seeds
seed.set <- new("seedset",GsMN = g, seeds = seeds)
}
}
\seealso{
\code{\link{getSeedSets}},\code{\link{getGsMN}},\code{\link{len}},
\code{\link{nonseed}},\code{\link{seedSize}},\code{\link{confidencescore}}
}

