% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vec-cumulative-functions.R
\name{chmean}
\alias{chmean}
\title{Cumulative Harmonic Mean}
\usage{
chmean(.x)
}
\arguments{
\item{.x}{A numeric vector}
}
\value{
A numeric vector
}
\description{
A function to return the cumulative harmonic mean of a vector.
}
\details{
A function to return the cumulative harmonic mean of a vector.
\code{1 / (cumsum(1 / .x))}
}
\examples{
x <- mtcars$mpg

chmean(x)

}
\seealso{
Other Vector Function: 
\code{\link{cgmean}()},
\code{\link{ckurtosis}()},
\code{\link{cmean}()},
\code{\link{cmedian}()},
\code{\link{crange}()},
\code{\link{csd}()},
\code{\link{cskewness}()},
\code{\link{cvar}()},
\code{\link{euclidean_distance}()},
\code{\link{kurtosis_vec}()},
\code{\link{rw_range}()},
\code{\link{skewness_vec}()}
}
\author{
Steven P. Sanderson II, MPH
}
\concept{Vector Function}
