#' @title Simulation data on needs-supplies fit processes (illustration)
#' @description Simulation data on needs-supplies fit processes in the context of student engagement at school (N= 500). For example, this could relate to needs and supplies in teacher autonomy support (Núñez-Regueiro et al., 2024a, 2024b) or in school environment characteristics (Fraser & Rentoul, 1980). The data was simulated to reflect a parallel asymmetric weak congruence and strong incongruence effect (polynomial family 26; Núñez-Regueiro et al., 2022, 2024c)
#'
#' @name sim_NSfit
#' @docType data
#' @author Fernando Núñez-Regueiro 
#' \email{fernando.nr.france@gmail.com}
#' @references 
#' Fraser, B.J., Rentoul, A.J. (1980).  Person-environment fit in open classrooms.\emph{The Journal of Educational Research}, 73(3), 159-167.  https://doi.org/10.1080/00220671.1980.10885227
#'
#' Núñez-Regueiro, F., Juhel, J. (2022). \emph{Model-Building Strategies in Response Surface Analysis.} Manuscript submitted for publication.
#' 
#' Núñez-Regueiro, F., Juhel, J., Wang, M-T. (2024a). \emph{Does Needs Satisfaction Reflect Positive Needs-Supplies Fit or Misfit? A New Look at Autonomy Supportive Contexts Using Cubic Response Surface Analysis.} Manuscript submitted for publication.
#'
#' Núñez-Regueiro, F., Santana-Monagas, E., Juhel, J. (2024b). \emph{How Needs-Supplies Fit With Teachers, Peers, and Parents Relate to Youth Outcomes} Manuscript submitted for publication. 
#'
#' Núñez-Regueiro, F., Juhel, J. (2024c). \emph{Response Surface Analysis for the Social Sciences I: Identifying Best-Fitting Polynomial Solutions.} Manuscript submitted for publication.
#' @keywords data
NULL
