% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KorAPQuery.R
\name{fetchNext,KorAPQuery-method}
\alias{fetchNext,KorAPQuery-method}
\alias{fetchNext}
\title{Fetch the next bunch of results of a KorAP query.}
\usage{
\S4method{fetchNext}{KorAPQuery}(
  kqo,
  offset = kqo@nextStartIndex,
  maxFetch = maxResultsPerPage,
  verbose = kqo@korapConnection@verbose,
  randomizePageOrder = FALSE
)
}
\arguments{
\item{kqo}{object obtained from \code{\link[=corpusQuery]{corpusQuery()}}}

\item{offset}{start offset for query results to fetch}

\item{maxFetch}{maximum number of query results to fetch}

\item{verbose}{print progress information if true}

\item{randomizePageOrder}{fetch result pages in pseudo random order if true. Use \code{\link[=set.seed]{set.seed()}} to set seed for reproducible results.}
}
\value{
The \code{kqo} input object with updated slots \code{collectedMatches}, \code{apiResponse}, \code{nextStartIndex}, \code{hasMoreMatches}
}
\description{
\strong{\code{fetchNext}} fetches the next bunch of results of a KorAP query.
}
\examples{
\dontrun{

q <- KorAPConnection() |>
  corpusQuery("Ameisenplage") |>
  fetchNext()
q@collectedMatches
}

}
\references{
\url{https://ids-pub.bsz-bw.de/frontdoor/index/index/docId/9026}
}
\seealso{
Other corpus search functions: 
\code{\link{corpusQuery,KorAPConnection-method}},
\code{\link{fetchAll,KorAPQuery-method}},
\code{\link{fetchAnnotations,KorAPQuery-method}}
}
\concept{corpus search functions}
