% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export_redcap_project.R
\name{export_content}
\alias{export_content}
\title{Export Content}
\usage{
export_content(content, uri = NULL, token = NULL, format = NULL, ...)
}
\arguments{
\item{content}{The element to export, see Details.}

\item{uri}{The URI for the REDCap API.  If \code{NULL} (default) the value
\code{Sys.getenv("REDCap_API_URI")} is used.}

\item{token}{The API token for the project you want to export from. If
\code{NULL} (default) the value \code{Sys.getenv("REDCap_API_TOKEN")} is
used.}

\item{format}{The format to return. If \code{NULL} (default) the value
\code{Sys.getenv("REDCap_API_format")} is used.}

\item{...}{additional arguments passed to \code{\link[curl]{handle_setform}}.}
}
\value{
The raw return from the REDCap API with the class
\code{rcer_raw_<content>}.
}
\description{
Export specific data elements from REDCap
}
\details{
The \code{content} and \code{format} arguments are used to control the
specific items to be exported, and in what format.  **Review the API
documentation**

The \code{uri}, \code{token}, and \code{format} arguments are set to
\code{NULL} by default and will look to the
\code{Sys.getenv("REDCap_API_URI")},
\code{Sys.getenv("REDCap_API_TOKEN")}, and
\code{Sys.getenv("REDCap_API_format")}, respectively, to define the values if
not explicitly done so by the end user.
}
\examples{

# A reproducible example would require a REDCap project, accessable via an
# API token.  An example of the return from these calls are provided as data
# with this package.

# avs_raw_metadata <- export_content(content = "metadata")
data(avs_raw_metadata)
str(avs_raw_metadata)

}
