% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CurveCalibration.R
\name{curve.calibration}
\alias{curve.calibration}
\title{Curve calibration}
\usage{
curve.calibration(
  yield.curve,
  market.assets = NULL,
  noSpots = NULL,
  analysis.date = Sys.Date(),
  asset.type = "IBRSwaps",
  freq = 4,
  rate.type = 0,
  daycount = NULL,
  fwd = 0,
  npieces = NULL,
  obj = "Price",
  Weights = NULL,
  nsimul = 1,
  piece.term = NULL,
  nodes = seq(0, 10, 0.001),
  approximation = "linear"
)
}
\arguments{
\item{yield.curve}{Internal rates of return of the market assets.
Series of rates with different maturities that adjust to the
time structure of the curve to calibrate and construct. \code{names(yield.curve)} needs to
include the numeric maturities in years of each rate, unless the input \code{market.assets} includes the maturities
as dates.}

\item{market.assets}{Matrix containing the market assets. The first column
contains the coupon rates of the assets and the second column represents their
corresponding maturities as a date. This input is only required if IRR's of assets differ from
coupon rate.}

\item{noSpots}{Number of spot interest rates introduced in the \code{yield.curve} input. Function assumes spots are the
first entries on the \code{yield.curve} vector.}

\item{analysis.date}{Date for which the curve is going to be calibrated and,
thus, constructed.}

\item{asset.type}{String that determines the asset type to value. See also
'Details'.}

\item{freq}{Frequency of payments of a given asset in a year. For LIBOR and
IBR the default frequency is four (quarterly payments). TES has a default
frequency of one (annual payments).}

\item{rate.type}{(1) for annual compounded discount rates and (0) for continuosly
compounded discount rates. By default, rates are assumed to be the former.}

\item{daycount}{Day count convention. See also 'Details'.}

\item{fwd}{Numeric value that determines if the desired output curve is a
forward or a spot curve. Set \code{0} for spot curve (default), \code{1}
otherwise.}

\item{npieces}{Number of constant or linear segments for the curve to incorporate. By
default \code{NULL}, and bootstrapping method is used, otherwise, minimization of
RSS is used.}

\item{obj}{String related to the definition of the error in the RSS methodology.
Set \code{"Price"} for minimization of error by price or \code{"Rate"} for
minimization of error by rate.}

\item{Weights}{Vector of weights used to dot product with residual squares in order to
calculate residual sum of squares. By default, each residual is assigned the same weight.}

\item{nsimul}{Number of simulations for the terms of the pieces. The more simulations,
the more likely to find a better local solution. By default \code{1}, and terms are
defined in such way each piece occupies the same length in the abscissa axis.}

\item{piece.term}{Vector that establishes a unique term structure for optimization to take place.
Each piece or segment must have a unique maturity, as numeric value in years,
that signifies the end of the segment. Last segment maturity must not be introduced, it is assumed to be equivalent to
the last term introduced on analysis date. Therefore, the \code{piece.term} vector must always have a length equal to \code{npieces} - 1.}

\item{nodes}{Desired output nodes of the curve.}

\item{approximation}{String that establish the approximation. Set
\code{'linear'} for a piecewise linear approximation, or \code{'constant'} for a
piecewise constant curve.}
}
\value{
Zero Coupon curve for a specific date based on historical spot rates
and bond structures.
}
\description{
Function that calibrates and returns a Zero Coupon curve based
on the coupon rates and IRR's of the assets. Uses the bootstrap method to find, recursively, the
corresponding Zero Coupon rates given by the market data. This rates are
then optimized by the minimization of the MAE between bond values given by
the constructed rates and bond market value. Alternatively, uses minimization of
residual sum of squares (RSS), allowing user to optimize or define an specific
term structure of the segments.
}
\details{
\code{asset.type} makes reference to the following type of assets:
\itemize{
   \item "TES" for Colombian Treasury Bonds (default).
   \item "IBRSwaps" for swaps indexed to IBR rate.
   \item "LIBORSwaps" for Interest Rate Swaps (IRS) indexed to 3M LIBOR.
   \item "FixedIncome" for assets that are indexed to a fixed income with
   different frequency of payments.
     }

If \code{npieces = NULL} uses a recursive iteration process based in
bootstrapping where the curve is constructed through a minimization of the MAE
between the dirty price of historical market assets and an approximation of the theoretical
price of assets of same maturity. Uses the "L-BFGS-B" optimization method
to minimize the expected MAE. Otherwise, curve is constructed through minimization
of RSS where the error can be defined via price or rate.
}
\examples{
# Create input
yield.curve <- c(0.103,0.1034,0.1092, 0.1161, 0.1233, 0.1280, 0.1310, 0.1320, 0.1325, 0.1320)
names(yield.curve) <- c(0,0.08,0.25,0.5,1,2,3,5,7,10)
nodes <- seq(0,10,0.001)

market.assets <- matrix(NA,nrow = 10,ncol = 2)
market.assets[1,1] <- 0.1030 ; market.assets[2,1]  <- 0.1044
market.assets[3,1] <- 0.1083 ; market.assets[4,1]  <- 0.1010
market.assets[5,1] <- 0.1120 ; market.assets[6,1]  <- 0.1130
market.assets[7,1] <- 0.1150 ; market.assets[8,1]  <- 0.1160
market.assets[9,1] <- 0.1150 ; market.assets[10,1] <- 0.13
market.assets[1,2] <- "2019-01-03" ; market.assets[2,2]  <- "2019-02-03"
market.assets[3,2] <- "2019-04-03" ; market.assets[4,2]  <- "2019-07-03"
market.assets[5,2] <- "2020-01-03" ; market.assets[6,2]  <- "2021-01-03"
market.assets[7,2] <- "2022-01-03" ; market.assets[8,2]  <- "2024-07-03"
market.assets[9,2] <- "2026-01-03" ; market.assets[10,2] <- "2029-01-03"

# Function
curve.calibration (yield.curve = yield.curve, market.assets = market.assets,
                  analysis.date = "2019-01-03" , asset.type = "IBRSwaps",
                  freq = 4, daycount = "ACT/365", fwd = 0, nodes = nodes,
                  approximation = "linear")


}
\author{
Andres Galeano & Camilo Díaz
}
