% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nomogram.R
\name{nomogram.crr}
\alias{nomogram.crr}
\title{Construct a Nomogram for a Competing Risks Regression Model}
\usage{
nomogram.crr(
  fit,
  failtime,
  ci = TRUE,
  ...,
  adj.to,
  lp = TRUE,
  lp.at,
  lplabel = "Linear Predictor",
  fun.at,
  fun.lp.at,
  funlabel = "Predicted Value",
  fun.side,
  interact = NULL,
  intercept = 1,
  conf.int = FALSE,
  col.conf = c(1, 12),
  conf.space = c(0.08, 0.2),
  conf.lp = c("representative", "all", "none"),
  est.all = TRUE,
  abbrev = FALSE,
  minlength = 4,
  maxscale = 100,
  nint = 10,
  label.every = 1,
  force.label = FALSE,
  xfrac = 0.35,
  cex.axis = 0.85,
  cex.var = 1,
  col.grid = FALSE,
  vnames = c("labels", "names"),
  varname.label = TRUE,
  varname.label.sep = "=",
  ia.space = 0.7,
  tck = -0.009,
  lmgp = 0.4,
  omit = NULL,
  naxes,
  points.label = "Points",
  total.points.label = "Total Points",
  total.sep.page = FALSE,
  total.fun,
  verbose = FALSE,
  total.min,
  total.max,
  mikeomit = NULL
)
}
\arguments{
\item{fit}{A model fit by \code{\link[QHScrnomo]{crr.fit}}}

\item{failtime}{A vector of time points to display failure probability axes for.}

\item{ci}{Should the failure probability be displayed? Defaults to \code{TRUE}. If \code{FALSE}, the event-free probability is displayed.}

\item{...}{Settings of variables to use in constructing axes.
If \code{datadist} was in effect, the default is to use \code{pretty(total range, nint)}
for continuous variables, and the class levels for discrete ones.
For \code{legend.nomabbrev}, \code{...} specifies optional parameters to pass to the legend.
Common ones are \code{bty = "n"} to suppress drawing the box. You may want to
specify a non-proportionally spaced font (e.g., courier) number if
abbreviations are more than one letter long. This will make the abbreviation
definitions line up (e.g., specify font = 2, the default for courier).
Ignored for print.}

\item{adj.to}{If \code{datadist} was not defined for all predictors, it is required to define adjustment settings for the undefined ones (e.g. \code{adj.to=list(age=50, sex="female")}).}

\item{lp}{Set to \code{FALSE} to suppress creation of an axis for scoring \eqn{X\beta}{X beta}. Defaults to \code{TRUE}.}

\item{lp.at}{If \code{lp=TRUE}, specifies a vector of settings of \eqn{X\beta}{X beta}. Default is to use \code{pretty(range of linear predictors, nint)}.}

\item{lplabel}{label for linear predictor axis. Default is \code{"Linear Predictor"}.}

\item{fun.at}{Function values to label on axis. Default \code{fun}
evaluated at \code{lp.at}. If more than one \code{fun} was specified,
using a vector for \code{fun.at} will cause all functions to be evaluated
at the same argument values. To use different values, specify a list of
vectors for \code{fun.at}, with elements corresponding to the different
functions (lists of vectors also applies to \code{fun.lp.at} and
\code{fun.side}).}

\item{fun.lp.at}{If you want to evaluate one of the functions at a
different set of linear predictor values than may have been used in
constructing the linear predictor axis, specify a vector or list of
vectors of linear predictor values at which to evaluate the function.
This is especially useful for discrete functions. The presence of this
attribute also does away with the need for \code{nomogram} to compute
numerical approximations of the inverse of the function.  It also allows
the user-supplied function to return \code{factor} objects, which is
useful when e.g. a single tick mark position actually represents a range.
If the \code{fun.lp.at} parameter is present, the \code{fun.at} vector
for that function is ignored.}

\item{funlabel}{Label for \code{fun} axis. If more than one function was
given but \code{funlabel} is of length one, it will be duplicated as needed. If
\code{fun} is a list of functions for which you specified names (see the
final example below), these names will be used as labels.}

\item{fun.side}{A vector or list of vectors of \code{side} parameters for
the \code{axis} function for labeling function values. Values may be 1 to
position a tick mark label below the axis (the default), or 3 for above
the axis. If for example an axis has 5 tick mark labels and the second
and third will run into each other, specify \code{fun.side=c(1,1,3,1,1)}
(assuming only one function is specified as \code{fun}).}

\item{interact}{When a continuous variable interacts with a discrete one,
axes are constructed so that the continuous variable moves within the
axis, and separate axes represent levels of interacting factors. For
interactions between two continuous variables, all but the axis variable
must have discrete levels defined in \code{interact}. For discrete
interacting factors, you may specify levels to use in constructing the
multiple axes. For continuous interacting factors, you must do this.
Examples: \code{interact=list(age=seq(10,70,by=10),
  treat=c("A","B","D"))}.}

\item{intercept}{For models such as the ordinal logistic model with
multiple intercepts, specifies which one to use in evaluating the linear
predictor.}

\item{conf.int}{Confidence levels to display for each scoring. Default is
\code{FALSE} to display no confidence limits. Setting \code{conf.int} to
\code{TRUE} is the same as setting it to \code{c(0.7, 0.9)}, with the
line segment between the 0.7 and 0.9 levels shaded using gray scale.}

\item{col.conf}{Colors corresponding to \code{conf.int}. Use fractions for
gray scale (for UNIX S-PLUS).}

\item{conf.space}{A 2-element vector with the vertical range within which
to draw confidence bars, in units of 1=spacing between main bars. Four
heights are used within this range (8 for the linear predictor if more
than 16 unique values were evaluated), cycling them among separate
confidence intervals to reduce overlapping.}

\item{conf.lp}{Default is \code{"representative"} to group all linear
predictors evaluated into deciles, and to show, for the linear predictor
confidence intervals, only the mean linear predictor within the deciles
along with the median standard error within the deciles. Set
\code{conf.lp="none"} to suppress confidence limits for the linear
predictors, and to \code{"all"} to show all confidence limits.}

\item{est.all}{To plot axes for only the subset of variables named in
\code{\dots{}}, set \code{est.all=FALSE}. Note: This option only works
when zero has a special meaning for the variables that are omitted from
the graph.}

\item{abbrev}{Set to \code{TRUE} to use the \code{abbreviate} function to
abbreviate levels of categorical factors, both for labeling tick marks
and for axis titles. If you only want to abbreviate certain predictor
variables, set \code{abbrev} to a vector of character strings containing
their names.}

\item{minlength}{Applies if \code{abbrev=TRUE}. Is the minimum
abbreviation length passed to the \code{abbreviate} function. If you set
\code{minlength=1}, the letters of the alphabet are used to label tick
marks for categorical predictors, and all letters are drawn no matter how
close together they are. For labeling axes (interaction settings),
\code{minlength=1} causes \code{minlength=4} to be used.}

\item{maxscale}{Default maximum point score is 100.}

\item{nint}{Number of intervals to label for axes representing continuous variables. See \code{\link{pretty}}.}

\item{label.every}{Specify \code{label.every=i} to label on every \code{i}th tick mark.}

\item{force.label}{Set to \code{TRUE} to force every tick mark intended to
be labeled to have a label plotted (whether the labels run into each
other or not)}

\item{xfrac}{Fraction of horizontal plot to set aside for axis titles}

\item{cex.axis}{Character size for tick mark labels}

\item{cex.var}{Character size for axis titles (variable names)}

\item{col.grid}{If \code{col.grid=1}, no gray scale is used, but an
ordinary line is drawn. If \code{0<col.grid<1}, a \code{col} (gray
scale) of \code{col.grid} is used to draw vertical reference lines for
major axis divisions and \code{col.grid/2} for minor divisions. The
default is \code{col.grid=FALSE}, i.e., reference lines are omitted.
Specifying \code{col.grid=TRUE} is the same as specifying a gray scale
level of \code{col.grid=.2} (5 for Windows S-PLUS).}

\item{vnames}{By default, variable labels are used to label axes. Set
\code{vnames="names"} to instead use variable names.}

\item{varname.label}{In constructing axis titles for interactions, the
default is to add \code{"(interacting.varname=level)"} on the right.
Specify \code{varname.label=FALSE} to instead use \code{"(level)"}.}

\item{varname.label.sep}{If \code{varname.label=TRUE}, you can change the
separator to something other than \code{=} by specifying this parameter.}

\item{ia.space}{When multiple axes are draw for levels of interacting
factors, the default is to group combinations related to a main effect.
This is done by spacing the axes for the second to last of these within a
group only 0.7 (by default) of the way down as compared with normal space
of 1 unit.}

\item{tck}{See \code{tck} under \code{par}.}

\item{lmgp}{Spacing between numeric axis labels and axis (see \code{par} for \code{mgp})}

\item{omit}{Vector of character strings containing names of variables for
which to suppress drawing axes. Default is to show all variables.}

\item{naxes}{Maximum number of axes to allow on one plot. If the nomogram
requires more than one "page", the "Points" axis will be repeated at the
top of each page when necessary.}

\item{points.label}{A character string giving the axis label for the points scale}

\item{total.points.label}{A character string giving the axis label for the total points scale}

\item{total.sep.page}{Set to \code{TRUE} to force the total points and later axes to be placed on a separate page}

\item{total.fun}{A user-provided function that will be executed before the
total points axis is drawn. Default is not to execute a function. This
is useful e.g. when \code{total.sep.page=TRUE} and you wish to use
\code{locator} to find the coordinates for positioning an abbreviation
legend before it's too late and a new page is started (i.e.,
\code{total.fun=function()print(locator(1))}).}

\item{verbose}{Set to \code{TRUE} to get printed output detailing how tick
marks are chosen and labeled for function axes. This is useful in seeing
how certain linear predictor values cannot be solved for using inverse
linear interpolation on the (requested linear predictor values, function
values at these lp values). When this happens you will see \code{NA}s in
the \code{verbose} output, and the corresponding tick marks will not
appear in the nomogram.}

\item{total.min}{Setting the minimal value in the total point axis on the nomogram.}

\item{total.max}{Setting the maximal value in the total point axis.}

\item{mikeomit}{The predictor variables specified by their names here will
not be shown in the nomogram. The predicted outcome based on this
reduced nomogram would be the same as if users were using the full
version of the nomogram by entering the some values for the predictors
remaining in the reduced nomogram but adjusted values for the hiden
predictors so that 0 points will be achieved from these hiden predictor
variables in the full nomogram.}
}
\value{
A list of class \code{"nomogram"} that contains information used in
plotting the axes. Please see \code{\link[rms]{nomogram}} for details.
}
\description{
Draws a partial nomogram from a \code{\link[QHScrnomo]{crr.fit}} object that can be used to manually obtain predicted values from from a competing risks regression model.
}
\examples{
data(prostate.dat)
dd <- datadist(prostate.dat)
options(datadist = "dd")
prostate.f <- cph(Surv(TIME_EVENT,EVENT_DOD == 1) ~ TX  + rcs(PSA,3) +
           BX_GLSN_CAT +  CLIN_STG + rcs(AGE,3) +
           RACE_AA, data = prostate.dat,
           x = TRUE, y= TRUE, surv=TRUE,time.inc = 144)
prostate.crr <- crr.fit(prostate.f,cencode = 0,failcode = 1)
## make a CRR nomogram
nomogram.crr(prostate.crr,failtime = 120,lp=FALSE,
funlabel = "Predicted 10-year cumulative incidence")

}
\references{
Banks J: Nomograms. Encylopedia of Statistical Sciences, Vol 6.
Editors: S Kotz and NL Johnson.  New York: Wiley; 1985.

Lubsen J, Pool J, van der Does, E: A practical device for the application
of a diagnostic or prognostic function.  Meth. Inform. Med. 17:127--129;
1978.

Wikipedia: Nomogram, \url{https://en.wikipedia.org/wiki/Nomogram}.

Michael W. Kattan, Glenn Heller and Murray F. Brennan (2003). A
competing-risks nomogram \cr for sarcoma-specific death following local
recurrence. Statistics in Medicine. \code{Stat Med}. 2003;22:3515-3525.
}
\seealso{
\code{\link[rms]{nomogram}} \code{\link[QHScrnomo]{nomogram.mk6}} \code{\link[QHScrnomo]{crr.fit}}
}
\author{
Changhong Yu, Michael Kattan, Ph.D \cr Department of Quantitative
Health Sciences\cr Cleveland Clinic\cr

Frank Harrell\cr
Department of Biostatistics\cr
Vanderbilt University\cr
\email{f.harrell@vanderbilt.edu}
}
\keyword{hplot}
\keyword{models}
\keyword{regression}
