% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qbms.R
\name{get_program_studies}
\alias{get_program_studies}
\title{Get the List of Trials, Studies, and Locations Information for the Current Selected Program}
\usage{
get_program_studies()
}
\value{
A data frame containing detailed information for each study within the program's trials, 
including trial names, study names, location information, and entry counts.
}
\description{
Retrieves comprehensive information about the trials, studies, and environments/locations
within the current active breeding program, as configured in the internal state object using 
the \code{\link{set_program}} function. This includes test and check entry counts for each study.
}
\examples{
if (interactive()) {
  set_qbms_config("https://bms.icarda.org/ibpworkbench")
  login_bms()
  set_crop("wheat")
  set_program("Wheat International Nurseries")
  program_studies <- get_program_studies()
  head(program_studies)
}

}
\seealso{
\code{\link{login_bms}}, \code{\link{set_crop}}, \code{\link{set_program}}
}
\author{
Khaled Al-Shamaa, \email{k.el-shamaa@cgiar.org}
}
