% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Glm.R
\name{predictGlm}
\alias{predictGlm}
\title{predict using a logistic regression model}
\usage{
predictGlm(plpModel, data, cohort)
}
\arguments{
\item{plpModel}{An object of type \code{plpModel} - a patient level
prediction model}

\item{data}{An object of type \code{plpData} - the patient level prediction
data extracted from the CDM.}

\item{cohort}{The population dataframe created using
\code{createStudyPopulation} who will have their risks predicted or a cohort
without the outcome known}
}
\value{
A dataframe containing the prediction for each person in the
population
}
\description{
Predict risk with a given plpModel containing a generalized linear model.
}
\examples{
coefficients <- data.frame(
  covariateId = c(1002),
  coefficient = c(0.05))
model <- createGlmModel(coefficients, intercept = -2.5)
data("simulationProfile")
plpData <- simulatePlpData(simulationProfile, n=50)
prediction <- predictGlm(model, plpData, plpData$cohorts)
# see the predicted risk values
head(prediction)
}
