% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fcn_plots.R
\name{plot_DataOverRT}
\alias{plot_DataOverRT}
\title{Plot some count data over time for each Raw file.}
\usage{
plot_DataOverRT(
  data,
  title,
  y_lab,
  x_lim = range(data$RT),
  y_max = max(data$counts)
)
}
\arguments{
\item{data}{A data.frame with columns as described above}

\item{title}{The plot title}

\item{y_lab}{Label of y-axis}

\item{x_lim}{Limits of the x-axis (2-tuple)}

\item{y_max}{Maximum of the y-axis (single value)}
}
\value{
GGplot object
}
\description{
The input is a data.frame with columns
  'RT' - RT in seconds, representing one bin
  'counts' - number of counts at this bin
  'fc.raw.file' - name of the Raw file
where each row represents one bin in RT.
}
\details{
At most nine(!) Raw files can be plotted. If more are given,
an error is thrown.
}
\examples{
 data = data.frame(fc.raw.file = rep(paste('file', letters[1:3]), each=30),
                            RT = seq(20, 120, length.out = 30),
                        counts = c(rnorm(30, 400, 20), rnorm(30, 250, 15), rnorm(30, 50, 15)))
 plot_DataOverRT(data, "some title", "count data")

}
