% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PLNmixturefit-S3methods.R
\name{sigma.PLNmixturefit}
\alias{sigma.PLNmixturefit}
\title{Extract variance-covariance of residuals 'Sigma'}
\usage{
\method{sigma}{PLNmixturefit}(object, ...)
}
\arguments{
\item{object}{an R6 object with class \code{\link{PLNmixturefit}}}

\item{...}{additional parameters for S3 compatibility. Not used}
}
\value{
A semi definite positive matrix of size p, assuming there are p species in the model.
}
\description{
Extract the variance-covariance matrix of the residuals, usually noted \deqn{\Sigma} in PLN models. This captures the correlation between the species in the latent space.
or PLNmixture, it is a weighted mean of the variance-covariance matrices of each component.
}
\examples{
data(trichoptera)
trichoptera <- prepare_data(trichoptera$Abundance, trichoptera$Covariate)
myPLN <- PLNmixture(Abundance ~ 1 + offset(log(Offset)),
           data = trichoptera, control = PLNmixture_param(smoothing = "none"))  \%>\% getBestModel()
sigma(myPLN) ## Sigma
}
\seealso{
\code{\link[=coef.PLNmixturefit]{coef.PLNmixturefit()}} for other ways to access \deqn{\Sigma}.
}
