% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PLNPCAfamily-S3methods.R,
%   R/PLNfamily-S3methods.R, R/PLNmixturefamily-S3methods.R,
%   R/PLNnetworkfamily-S3methods.R
\name{getBestModel.PLNPCAfamily}
\alias{getBestModel.PLNPCAfamily}
\alias{getBestModel}
\alias{getBestModel.PLNmixturefamily}
\alias{getBestModel.Networkfamily}
\alias{getBestModel.PLNnetworkfamily}
\alias{getBestModel.ZIPLNnetworkfamily}
\title{Best model extraction from a collection of models}
\usage{
\method{getBestModel}{PLNPCAfamily}(Robject, crit = c("ICL", "BIC"), ...)

getBestModel(Robject, crit, ...)

\method{getBestModel}{PLNmixturefamily}(Robject, crit = c("ICL", "BIC"), ...)

\method{getBestModel}{Networkfamily}(Robject, crit = c("BIC", "EBIC", "StARS"), ...)

\method{getBestModel}{PLNnetworkfamily}(Robject, crit = c("BIC", "EBIC", "StARS"), ...)

\method{getBestModel}{ZIPLNnetworkfamily}(Robject, crit = c("BIC", "EBIC", "StARS"), ...)
}
\arguments{
\item{Robject}{an object with class PLNPCAfamilly ot PLNnetworkfamily}

\item{crit}{a character for the criterion used to performed the selection. Either
"BIC", "ICL", "EBIC", "StARS", "R_squared". Default is \code{ICL} for \code{PLNPCA}, and \code{BIC} for \code{PLNnetwork}.
If StARS (Stability Approach to Regularization Selection) is chosen and stability selection
was not yet performed, the function will call the method \code{\link[=stability_selection]{stability_selection()}} with default argument.}

\item{...}{additional parameters for StARS criterion (only for \code{PLNnetwork}). \code{stability}, a scalar indicating the target stability (= 1 - 2 beta) at which the network is selected. Default is \code{0.9}.}
}
\value{
Send back an object with class \code{\link{PLNPCAfit}} or \code{\link{PLNnetworkfit}}
}
\description{
Best model extraction from a collection of models
}
\section{Methods (by class)}{
\itemize{
\item \code{getBestModel(PLNPCAfamily)}: Model extraction for \code{\link{PLNPCAfamily}}

\item \code{getBestModel(PLNmixturefamily)}: Model extraction for \code{\link{PLNmixturefamily}}

\item \code{getBestModel(Networkfamily)}: Model extraction for \code{\link{PLNnetworkfamily}} or \code{\link{ZIPLNnetworkfamily}}

\item \code{getBestModel(PLNnetworkfamily)}: Model extraction for \code{\link{PLNnetworkfamily}}

\item \code{getBestModel(ZIPLNnetworkfamily)}: Model extraction for \code{\link{ZIPLNnetworkfamily}}

}}
\examples{
\dontrun{
data(trichoptera)
trichoptera <- prepare_data(trichoptera$Abundance, trichoptera$Covariate)
myPCA <- PLNPCA(Abundance ~ 1 + offset(log(Offset)), data = trichoptera, ranks = 1:4)
myModel <- getBestModel(myPCA)
}
}
