% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sparse.R
\name{sparse_mean}
\alias{sparse_mean}
\title{Calculate the mean concentration at all time points for use in sparse NCA
calculations}
\usage{
sparse_mean(
  sparse_pk,
  sparse_mean_method = c("arithmetic mean, <=50\% BLQ", "arithmetic mean")
)
}
\arguments{
\item{sparse_pk}{A sparse_pk object from \code{\link[=as_sparse_pk]{as_sparse_pk()}}}

\item{sparse_mean_method}{The method used to calculate the sparse mean (see
details)}
}
\value{
A vector the same length as \code{sparse_pk} with the mean concentration
at each of those times.
}
\description{
Choices for the method of calculation (the argument \code{sparse_mean_method})
are:
}
\details{
\describe{
\item{"arithmetic mean"}{Arithmetic mean (ignoring number of BLQ samples)}
\item{"arithmetic mean, <=50\% BLQ"}{If >= 50\% of the measurements are BLQ, zero.  Otherwise, the arithmetic mean of all samples (including the BLQ as zero).}
}
}
\seealso{
Other Sparse Methods: 
\code{\link{as_sparse_pk}()},
\code{\link{pk.calc.sparse_auc}()},
\code{\link{sparse_auc_weight_linear}()}
}
\concept{Sparse Methods}
