% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PGBOAlgorithm.R
\docType{class}
\name{PGBOAlgorithm-class}
\alias{PGBOAlgorithm-class}
\alias{PGBOAlgorithm}
\title{Class "PGBOAlgorithm"}
\description{
The class "PGBOAlgorithm" implements the PGBO algorithm: Population Genetics Based Optimizer,
developed by Hervé Le Nagard [1].
}
\section{Objects from the Class \code{PGBOAlgorithm}}{

Objects form the Class \code{PGBOAlgorithm} can be created by calls of the form \code{PGBOAlgorithm(...)} where
(...) are the parameters for the \code{PGBOAlgorithm} objects.
}

\section{Slots for \code{PGBOAlgorithm} objects}{

 \describe{
   \item{\code{N}:}{A numeric giving the population size.}
   \item{\code{muteEffect}:}{A numeric giving the mutation effect.}
   \item{\code{maxIteration}:}{A numeric giving the maximum number of iterations.}
   \item{\code{seed}:}{A numeric giving the seed.}
   \item{\code{showProcess}:}{A boolean to show or not the process.}
   \item{\code{optimalDesign}:}{A \code{Design} object giving the optimal design.}
   \item{\code{iterationAndCriteria}:}{A list giving the optimal criteria at each iteration.}
 }
}

\references{
[1] Rebecca Bauer, France Mentré, Halima Kaddouri, Jacques Le Bras, Hervé Le Nagard,
Benefits of a new Metropolis-Hasting based algorithm, in non-linear regression for estimation of ex vivo antimalarial sensitivity in patients infected with two strains,
Computers in Biology and Medicine, Volume 55, 2014, Pages 16-25, ISSN 0010-4825
}
