% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rgl-3d.r
\name{biplotSlater3d}
\alias{biplotSlater3d}
\title{Draw the Slater's INGRID biplot in rgl (3D device).}
\usage{
biplotSlater3d(x, center = 1, g = 1, h = 1, ...)
}
\arguments{
\item{x}{\code{repgrid} object.}

\item{center}{Numeric. The type of centering to be performed.
0= no centering, 1= row mean centering (construct),
2= column mean centering (elements), 3= double-centering (construct and element means),
4= midpoint centering of rows (constructs).
Default is \code{1} (row i.e. construct centering).}

\item{g}{Power of the singular value matrix assigned to the left singular
vectors, i.e. the constructs.}

\item{h}{Power of the singular value matrix assigned to the right singular
vectors, i.e. the elements.}

\item{...}{Additional arguments to be passed to biplot3d.}
}
\description{
The 3D biplot opens an interactive
3D device that can be rotated and zoomed using the mouse.
A 3D device facilitates the exploration of grid data as
significant proportions of the sum-of-squares are often
represented beyond the first two dimensions. Also, in a lot of
cases it may be of interest to explore the grid space from
a certain angle, e.g. to gain an optimal view onto the set
of elements under investigation (e.g. Raeithel, 1998).
Note that Slater's biplot is just a special case of a biplot
that can be produced using the \code{\link[=biplot3d]{biplot3d()}}
function with the arguments \verb{center=1, g=1, h=1}.
}
\examples{
\dontrun{

biplotSlater3d(boeker)
biplotSlater3d(boeker, unity3d = T)

biplotSlater3d(boeker,
  e.sphere.col = "red",
  c.text.col = "blue"
)
biplotSlater3d(boeker, e.cex = 1)
biplotSlater3d(boeker, col.sphere = "red")
}

}
\seealso{
Unsophisticated biplot: \code{\link[=biplotSimple]{biplotSimple()}}; \cr
2D biplots:
\code{\link[=biplot2d]{biplot2d()}},
\code{\link[=biplotEsa2d]{biplotEsa2d()}},
\code{\link[=biplotSlater2d]{biplotSlater2d()}};\cr
Pseudo 3D biplots:
\code{\link[=biplotPseudo3d]{biplotPseudo3d()}},
\code{\link[=biplotEsaPseudo3d]{biplotEsaPseudo3d()}},
\code{\link[=biplotSlaterPseudo3d]{biplotSlaterPseudo3d()}};\cr
Interactive 3D biplots:
\code{\link[=biplot3d]{biplot3d()}},
\code{\link[=biplotEsa3d]{biplotEsa3d()}},
\code{\link[=biplotSlater3d]{biplotSlater3d()}};\cr
Function to set view in 3D:
\code{\link[=home]{home()}}.
}
