% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_npx_parquet.R
\name{read_npx_parquet}
\alias{read_npx_parquet}
\title{Helper function to read in Olink Explore parquet output files}
\usage{
read_npx_parquet(filename)
}
\arguments{
\item{filename}{Path to Olink Software parquet output file.}
}
\value{
A "tibble" in long format. Some of the columns are:
\itemize{
\item{SampleID:} Sample ID
\item{OlinkID:} Olink ID
\item{UniProt:} UniProt ID
\item{Assay:} Protein symbol
\item{PlateID:} Plate ID
\item{Count:} Counts from sequences
\item{ExtNPX:} External control normalized counts
\item{NPX:} Normalized Protein Expression
}
Additional columns may be present or missing depending on the platform
}
\description{
Helper function to read in Olink Explore parquet output files
}
\examples{
\donttest{
file <- system.file("extdata", "Example_NPX_Data.csv", package = "OlinkAnalyze")
read_NPX(file)
}

}
\keyword{NPX}
