% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GraphicalOutputs.R
\name{RiskFactorsGraphs}
\alias{RiskFactorsGraphs}
\title{Spanned and unspanned factors plot}
\usage{
RiskFactorsGraphs(
  ModelType,
  ModelOutputs,
  Economies,
  FactorLabels,
  Folder2save
)
}
\arguments{
\item{ModelType}{A character vector indicating the  estimated model type}

\item{ModelOutputs}{list of model parameter estimates (see the \code{\link{Optimization}} function)}

\item{Economies}{A character vector containing the names of the economies included in the system.}

\item{FactorLabels}{A character vector indicating the model type to be estimated.}

\item{Folder2save}{Folder path where the outputs will be stored.}
}
\description{
Spanned and unspanned factors plot
}
\section{Available Methods}{

- `autoplot(object, type = "RiskFactors")`
}

\examples{
data("ParaSetEx")
# Adapt factor labels according to the example
ModelType <- "JPS original"
Economy <- "Brazil"
FacLab <- LabFac(N = 1, DomVar ="Eco_Act" , GlobalVar = "Gl_Eco_Act", Economy, ModelType)

RiskFactorsGraphs(ModelType, ModelParaEx, Economy, FacLab, Folder2save = NULL)

}
