% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{samplePsis}
\alias{samplePsis}
\title{Example transition probabilities (psis) between origin and target sites}
\format{
A named list with 8 transition probability matrices in it. The
direction is from origin site (rows) to target sites (columns), so each
row of each matrix sums to 1.  The psi matrices are:
\itemize{
  \item Full Mix: Full mixing from all origin sites to all target sites
  \item Avoid One Site: All origin sites have the same transition
     probabilities, mostly avoiding target site 4
  \item Full Connectivity: Each origin site transitions to only one target
     site
  \item Half Mix: Origin sites A and B mix fully between target sites 1 and
     2, but don't move to target sites 3 or 4, while origin sites C and D
     mix fully between target sites 3 and 4, but don't move to target sites
     1 or 2
  \item Low: Simulation scenario labelled "Moderate Connectivity" in Cohen
     et al. (2014)
  \item Medium: Simulation scenario labelled "Strong Connectivity" in Cohen
     et al. (2014)
  \item One Site Preference: Three origin sites have full mixing, but origin
     site D only goes to target site 4
  \item Negative: Artificial transition probability scenario developed to
     produce a negative MC value under some circumstances
}
}
\usage{
samplePsis
}
\description{
A dataset containing example psi matrices used in Cohen et al. (2018).
}
\keyword{datasets}
