% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estConnectivity.R
\name{diffMantel}
\alias{diffMantel}
\alias{diffCorr}
\title{Pairwise differences between two or more independent Mantel correlation
estimates}
\usage{
diffMantel(estimates, nSamples = 1e+05, alpha = 0.05, returnSamples = FALSE)

diffCorr(estimates, nSamples = 1e+05, alpha = 0.05, returnSamples = FALSE)
}
\arguments{
\item{estimates}{List of at least two Mantel correlation estimates, provided
by either the estMC or the estMantel functions. If this is a named list
(recommended), the function will use these names in labeling the
differences.}

\item{nSamples}{A positive integer, number of samples (with replacement)
to draw from each pair of MC estimates (default 100000).  If set to NULL,
compares all Mantel correlation samples from each pair.}

\item{alpha}{Level for confidence/credible intervals provided.}

\item{returnSamples}{Should the function return all the sampled differences?
Defaults to FALSE to reduce storage requirements. Change to TRUE to
compute your own summary statistics.}
}
\value{
\code{diffMantel} returns a list with elements:
\describe{
  \item{\code{meanDiff, medianDiff}}{Vectors with mean and medians of sampled
     differences for each pairwise comparison. Estimates of difference
     between rM values incorporating parametric uncertainty.}
  \item{\code{seDiff}}{Vector with standard errors of rM differences for each
     pairwise comparison, estimated from SD of sampled differences.}
  \item{\code{simpleCI}}{Matrix of \code{1 - alpha} confidence intervals for
     rM differences, estimated as \code{alpha/2} and \code{1 - alpha/2}
     quantiles of \code{sampleCorr}.}
  \item{\code{bcCI}}{Matrix of bias-corrected \code{1 - alpha} confidence
     intervals for rM differences for each pairwise comparison. Preferable
     to \code{simpleCI} when \code{meanDiff} is the best estimate of the rM
     difference. \code{simpleCI} is preferred when
     \code{medianDiff} is a better estimator. When \code{meanDiff==medianDiff},
     these should be identical.  Estimated as the
     \code{pnorm(2 * z0 + qnorm(alpha / 2))} and
     \code{pnorm(2 * z0 + qnorm(1 - alpha / 2))} quantiles of sampled
     differences, where z0 is the proportion of \code{sampleDiff < meanDiff}.}
  \item{\code{sampleDiff}}{Only provided if \code{returnSamples} is TRUE.
     List of sampled values for each pairwise rM difference.}
}
}
\description{
Estimates mean (and median) differences in Mantel correlations (rM), and
includes measures of uncertainty (SE and CI).  For those measures of
uncertainty to be accurate, only apply this function to rM estimates where
all data sources are independent (e.g., different species).
}
\references{
Cohen, E. B., C. S. Rushing, F. R. Moore, M. T. Hallworth, J. A. Hostetler,
M. Gutierrez Ramirez, and P. P. Marra. 2019. The strength of
migratory connectivity for birds en route to breeding through the Gulf of Mexico.
}
