% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lib_iKernel.R
\name{iKernel}
\alias{iKernel}
\alias{iKernel_point_dataset}
\alias{get_weights_iKernel}
\alias{GRAM_iKernel}
\title{Function returns the value of similarity or Isolation KERNEL for TWO points}
\usage{
iKernel(Matrix_iKernel, pnt_1, pnt_2, t)

iKernel_point_dataset(Matrix_iKernel, t, nr, iFeature_point)

get_weights_iKernel(GI, Matrix_iKernel, t, nr, iFeature_point)

GRAM_iKernel(Matrix_iKernel, check_pos_def = FALSE)
}
\arguments{
\item{Matrix_iKernel}{Matrix of indexes of Voronoi cells for each point and each tree based on Isolation Kernel calculation}

\item{pnt_1}{The first point of dataset}

\item{pnt_2}{The second point of dataset}

\item{t}{is a number of columns of Matrix_iKernel or dimension of Matrix_iKernel (corresponding to the number of trees t)}

\item{nr}{is number of rows in Matrix_iKernel or size of dataset}

\item{iFeature_point}{Feature mapping in RKHS for a new point, that can be gotten via \code{add_new_point_iKernel()} function}

\item{GI}{The inverse Gram matrix}

\item{check_pos_def}{Logical parameter to check the Gram matrix is positive definite or do not check}
}
\value{
The function \code{iKernel()} returns a value of similarity or Isolation KERNEL for TWO points

The function \code{iKernel_point_dataset()} returns a value of Isolation Kernel between a new point and dataset represented via Matrix_iKernel

The function \code{get_weights_iKernel()} returns the
list of weights for RKHS space and weights of similarity for iFeature_point

The function \code{GRAM_iKernel()} returns Gram matrix of Isolation Kernel
}
\description{
\code{iKernel()} function returns value of similarity or Isolation KERNEL
for TWO points that is number in the range \code{[0,1]}

\code{iKernel_point_dataset()} function returns vector of values of similarity based on Isolation Kernel between a new point and all the points of dataset

\code{get_weights_iKernel()} function returns list of two objects:
the first object is numeric vector of weights for RKHS space, and
the second object is numeric vector of weights of similarity for iFeature_point
corresponding observation point

\code{GRAM_iKernel()} is the function to calculate Gram matrix for Isolation Kernel method based on Voronoi diagrams
}
\section{Functions}{
\itemize{
\item \code{iKernel_point_dataset()}: The function to get Isolation Kernel between a new point and dataset

\item \code{get_weights_iKernel()}: The function to get weights from Feature mapping

\item \code{GRAM_iKernel()}: The function to calculate Gram matrix for Isolation Kernel method

}}
\examples{
NULL
NULL
NULL 
NULL
}
\keyword{internal}
