% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TwoSamplesHT2.R
\name{TwoSamplesHT2}
\alias{TwoSamplesHT2}
\title{Two Independent Samples Hotelling T^2 Test}
\usage{
TwoSamplesHT2(data, group, alpha = 0.05, Homogenity = TRUE)
}
\arguments{
\item{data}{a data frame.}

\item{group}{a group vector consisting of 1 and 2 values.}

\item{alpha}{Significance Level that will be used for confidence intervals. 
default=0.05}

\item{Homogenity}{a logical argument. If sample covariance matrices are 
homogeneity,then \code{Homogenity=TRUE}. Otherwise \code{Homogenity=FALSE} 
The homogeneity of covariance matrices can be investigated with \code{BoxM} function.}
}
\value{
a list with 8 elements:
\item{HT2}{The value of Hotelling T^2 Test Statistic}
\item{F}{The value of F Statistic}
\item{df}{The F statistic's degree of freedom}
\item{p.value}{p value}
\item{CI}{The lower and upper limits of confidence intervals obtained for 
all variables}
\item{alpha}{The alpha value using in confidence intervals}
\item{Descriptive1}{Descriptive Statistics for the first group}
\item{Descriptive2}{Descriptive Statistics for the second group}
}
\description{
\code{TwoSamplesHT2} function computes Hotelling T^2 statistic for two 
independent samples and gives confidence intervals.
}
\details{
This function computes two independent samples Hotelling T^2 statistics
that is used to test   
whether two population mean vectors are equal to each other.
When \code{H0} is rejected, this function computes confidence intervals
for all variables to determine variable(s) affecting on rejection decision.
Moreover, when covariance matrices are not homogeneity, the approach proposed
by D. G. Nel and V. D. Merwe (1986) is used.
}
\examples{

data(iris)
G<-c(rep(1,50),rep(2,50))
# When covariances matrices are homogeneity
results1 <- TwoSamplesHT2(data=iris[1:100,1:4],group=G,alpha=0.05)
summary(results1)
# When covariances matrices are not homogeneity
results2 <- TwoSamplesHT2(data=iris[1:100,1:4],group=G,Homogenity=FALSE)
summary(results2)
}
\references{
Rencher, A. C. (2003). Methods of multivariate analysis 
(Vol. 492). John Wiley & Sons.

Tatlidil, H. (1996). Uygulamali Cok Degiskenli Istatistiksel 
Yontemler. Cem Web.

D.G. Nel & C.A. Van Der Merwe (1986) A solution to the 
multivariate behrens fisher problem, Communications in Statistics:Theory and
 Methods, 15:12, 3719-3735
}
\author{
Hasan BULUT <hasan.bulut@omu.edu.tr>
}
