% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/htest_MomentTest.R
\name{DLMCTest}
\alias{DLMCTest}
\title{Monte Carlo moment-based test for Markov switching model}
\usage{
DLMCTest(Y, p, control = list())
}
\arguments{
\item{Y}{Series to be tested}

\item{p}{Number of autoregressive lags.}

\item{control}{List with test procedure options including: 
\itemize{
  \item N: Integer determining the number of Monte Carlo simulations. Default is set to \code{99} as in paper.
  \item simdist_N: Integer determining the number of simulations for CDF distribution approximation. Default is set to \code{10000}.
  \item getSE: Boolean indicator. If \code{TRUE}, standard errors for restricted model are estimated. If \code{FALSE} no standard errors are estimated. Default is \code{TRUE}.
}}
}
\value{
List of class \code{DLMCTest} (\code{S3} object) with attributes including: 
\itemize{
  \item mdl_h0: List with restricted model attributes. This will be of class \code{ARmdl} if \code{p>0} or \code{Nmdl} otherwise (\code{S3} objects). See \code{\link{ARmdl}} or \code{\link{Nmdl}}.    
  \item theta: Value of nuisance parameters. Specifically, these are the consistent estimates of nuisance parameters as discussed in Dufour & Luger (2017) LMC procedure.
  \item S0: A (\code{1 x 4})) matrix containing the four moment-based test statistics defined in (\code{11}) - (\code{14}) in Dufour & Luger (2017).
  \item F0_min: Test statistic value for min version of Local Monte Carlo moment-based test.
  \item F0_prod: Test statistic value for prod version of Local Monte Carlo moment-based test.
  \item FN_min: A (\code{N x 1}) vector with simulated test statistics for min version of Local Monte Carlo moment-based test under null hypothesis.
  \item FN_prod: A (\code{N x 1}) vector with simulated test statistics for prod version of Local Monte Carlo moment-based test under null hypothesis.
  \item pval_min: P-value for min version of Local Monte Carlo moment-based test.
  \item pval_prod: P-value for prod version of Local Monte Carlo moment-based test.
  \item FN_min_cv: Vector with 90\%, 95\%, and 99\% Monte Carlo critical values for min version of Local Monte Carlo moment-based test.
  \item FN_prod_cv: Vector with 90\%, 95\%, and 99\% Monte Carlo critical values for prod version of Local Monte Carlo moment-based test.
  \item control: List with test procedure options used.
}
}
\description{
This function performs the Local Monte Carlo moment-based test for
Markov switching autoregressive models proposed in Dufour & Luger (2017).
}
\examples{
set.seed(1234)
# load data used in Hamilton 1989 and extended data used in CHP 2014 
y84 <- as.matrix(hamilton84GNP$GNP_gr)
y10 <- as.matrix(chp10GNP$GNP_gr)

# Set test procedure options
lmc_control = list(N = 99,
                   simdist_N = 10000,
                   getSE = TRUE)

# perform test on Hamilton 1989 data
lmc_gnp84 <- DLMCTest(y84, p = 4, control = lmc_control)
summary(lmc_gnp84)

}
\references{
Dufour, J. M., & Luger, R. 2017. "Identification-robust moment-based tests for 
Markov switching in autoregressive models." \emph{Econometric Reviews}, 36(6-9), 713-727.
}
