% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Class_definitions.R
\docType{class}
\name{Imp-class}
\alias{Imp-class}
\title{Class \code{'Imp'}}
\description{
An operating model component that specifies the degree of adherence to management recommendations (Implementation error)
}
\section{Slots}{

\describe{
\item{\code{Name}}{The name of the Implementation error object. Single value. Character string.}

\item{\code{Name}}{The name of the Implementation error object. Single value.
Character string.}

\item{\code{TACFrac}}{Mean fraction of recommended TAC that is actually taken. For
each historical simulation a single value is drawn from a uniform distribution
specified by the upper and lower bounds provided. This value is the mean TAC
fraction obtained across all years of that simulation, and a yearly TAC frac is
drawn from a log-normal distribution with the simulation mean and a coefficient
of variation specified by the value of \code{TACSD} drawn for that simulation. If
the value drawn is greater than 1 the amount of catch taken is greater than
that recommended by the TAC, and if it is less than 1 the amount of catch taken
is less than that recommended by the TAC. Positive real numbers.}

\item{\code{TACSD}}{Log-normal coefficient of variation in the fraction of
recommended TAC that is actually taken. For each historical simulation a single
value is drawn from a uniform distribution specified by the upper and lower
bounds provided. This value is used, along with the \code{TACFrac} drawn for that
simulation, to create a log-normal distribution that yearly values specifying
the actual amount of catch taken are drawn from. Positive real numbers.}

\item{\code{TAEFrac}}{Mean fraction of recommended TAE that is actually taken. For
each historical simulation a single value is drawn from a uniform distribution
specified by the upper and lower bounds provided. This value is the mean TAE
fraction obtained across all years of that simulation, and a yearly TAE frac is
drawn from a log-normal distribution with the simulation mean and a coefficient
of variation specified by the value of \code{TAESD} drawn for that simulation. If
the value drawn is greater than 1 the amount of effort employed is greater than
that recommended by the TAE, and if it is less than 1 the amount of effort
employed is less than that recommended by the TAE. Positive real numbers.}

\item{\code{TAESD}}{Log-normal coefficient of variation in the fraction of
recommended TAE that is actually taken. For each historical simulation a single
value is drawn from a uniform distribution specified by the upper and lower
bounds provided. This value is used, along with the \code{TAEFrac} drawn for that
simulation, to create a log-normal distribution that yearly values speciying
the actual amount of efort employed are drawn from. Positive real numbers.}

\item{\code{SizeLimFrac}}{Mean fraction of recommended size limit that is actually
retained. For each historical simulation a single value is drawn from a uniform
distribution specified by the upper and lower bounds provided. This value is
the mean size limit fraction obtained across all years of that simulation, and
a yearly size limit fraction is drawn from a log-normal distribution with the
simulation mean and a coefficient of variation specified by the value of
\code{SizeLimSD} drawn for that simulation. If the value drawn is greater than 1 the
size of fish retained is greater than that recommended by the size limit, and
if it is less than 1 the amount of size of fish retained is less than that
recommended by the size limit. Positive real numbers.}

\item{\code{SizeLimSD}}{Log-normal coefficient of variation in the fraction of
recommended size limit that is actually retained. For each historical
simulation a single value is drawn from a uniform distribution specified by the
upper and lower bounds provided. This value is used, along with the
\code{SizeLimFrac} drawn for that simulation, to create a log-normal distribution
that yearly values speciying the actual fraction of the size limit retained are
drawn from. Positive real numbers.}
}}

\section{Objects from the Class}{
 Objects can be created by calls of the form
\code{new('Imp')}#'
}

\examples{

showClass('Imp')

}
\author{
T. Carruthers and A. Hordyk
}
\keyword{classes}
