% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/criteria_GL.R
\name{criteria.GL}
\alias{criteria.GL}
\title{Calculates the values of the Generalised L-criterion and its components}
\usage{
criteria.GL(X1, X2, search.object, eps = 10^-23)
}
\arguments{
\item{X1}{The primary model matrix, with the first column containing the labels of treatments, and the second -- the intercept term.}

\item{X2}{The matrix of potential terms, with the first column containing the labels of treatments.}

\item{search.object}{Object of class \code{\link[=mood]{mood()}} specifying experiment parameters.}

\item{eps}{Computational tolerance, the default value is 10^-23}
}
\value{
A list of values: indicator of whether the evaluation was successful ("eval"), Ls-criterion value -- intercept excluded ("Ls"),
Lack-of-fit criterion value ("LoF"), the bias component value ("bias"), the number of pure error degrees of freedom ("df")
and the value of the compound criterion ("compound").
}
\description{
This function evaluates the Generalised L-criterion \insertCite{Goos2005model}{MOODE} for given primary and potential model matrices.
}
\examples{
#Experiment: one 5-level factor, primary model -- full quadratic, one potential (cubic) term
# setting up the example
ex.mood <- mood(K = 1, Levels = 5, Nruns = 7, criterion.choice = "GL", 
               kappa = list(kappa.L = 1./3, kappa.LoF = 1./3, kappa.bias = 1./3), 
               model_terms = list(primary.model = "second_order", potential.model = "cubic_terms"))
# Generating candidate set: orthonormalised
K <- ex.mood$K
Levels <- ex.mood$Levels 
cand.not.orth <- candidate_set_full(candidate_trt_set(Levels, K), K)
cand.full.orth <- candidate_set_orth(cand.not.orth, ex.mood$primary.terms, ex.mood$potential.terms)
# Choosing a design
index <- c(rep(1, 2), 3, 4, rep(5, 3))
X.primary <- cand.full.orth[index, c(1, match(ex.mood$primary.terms, colnames(cand.full.orth)))]
X.potential <- cand.full.orth[index, 
(c(1, match(ex.mood$potential.terms, colnames(cand.full.orth))))]
# Evaluating a compound GD-criterion
criteria.GL(X1 = X.primary, X2 = X.potential, ex.mood)
# Output: eval = 1, L = 0.3118626, LoF = 0.7212544, bias = 1.473138, df = 3, compound = 0.6919878

}
\references{
\insertAllCited
}
