% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ingrowth_modul.R
\name{predict_ingrowth}
\alias{predict_ingrowth}
\title{predict_ingrowth}
\usage{
predict_ingrowth(
  df_fit,
  df_predict,
  site_vars = site_vars,
  include_climate = include_climate,
  eval_model_ingrowth = TRUE,
  k = 10,
  blocked_cv = TRUE,
  ingrowth_model = "glm",
  rf_mtry = NULL,
  ingrowth_table = NULL,
  DBH_distribution_parameters = NULL
)
}
\arguments{
\item{df_fit}{a plot-level data with plotID, stand variables and site
descriptors, and the two target variables describing the number of ingrowth
trees for inner (ingrowth_3) and outer (ingrowth_15) circles}

\item{df_predict}{data frame which will be used for ingrowth predictions}

\item{site_vars}{a character vector of variable names which are used as site
descriptors}

\item{include_climate}{logical, should climate variables be included as
predictors}

\item{eval_model_ingrowth}{logical, should the the ingrowth model be
evaluated and returned as the output}

\item{k}{the number of folds to be used in the k fold cross-validation}

\item{blocked_cv}{logical, should the blocked cross-validation be used in the
evaluation phase?}

\item{ingrowth_model}{model to be used for ingrowth predictions. 'glm' for
generalized linear models (Poisson regression), 'ZIF_poiss' for zero inflated
Poisson regression and 'rf' for random forest}

\item{rf_mtry}{a number of variables randomly sampled as candidates at
each split of a random forest model for predicting ingrowth. If NULL, default
settings are applied.}

\item{ingrowth_table}{a data frame with 4 variables: (ingrowth) code,
DBH_threshold, DBH_max and weight. Ingrowth table is used within the ingrowth
sub model to correctly simulate different ingrowth levels and associated
upscale weights}

\item{DBH_distribution_parameters}{A list with deciles of DBH distributions
that are used to simulate DBH for new trees, separately for each ingrowth
category}
}
\value{
a list with four elements:
\enumerate{
 \item $predicted_ingrowth - a data frame with newly added trees based on the ingrowth predictions
 \item $eval_ingrowth - a data frame with predicted and observed number of new trees, separately for each ingrowth level, or character string indicating that ingrowth model was not evaluated
 \item $mod_ing_3 - the output model for predicting the ingrowth of trees with code 3
 \item $mod_ing_15 - the output model for predicting the ingrowth of trees with code 15 (the output name depends on the code used for this particular ingrowth level)
}
}
\description{
ingrowth model for predicting new trees within the MLFS
}
\examples{

library(MLFS)

data(data_v6)
data(data_ingrowth)
data(ingrowth_table)
data(ingrowth_parameter_list)

ingrowth_outputs <- predict_ingrowth(
   df_fit = data_ingrowth,
   df_predict = data_v6,
   site_vars = c("slope", "elevation", "northness", "siteIndex"),
   include_climate = TRUE,
   eval_model_ingrowth = FALSE,
   rf_mtry = 3,
   k = 10, blocked_cv = TRUE,
   ingrowth_model = 'rf',
   ingrowth_table = ingrowth_table,
   DBH_distribution_parameters = ingrowth_parameter_list)

}
