% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Luminescence-generics.R
\name{set_RLum}
\alias{set_RLum}
\title{General setter function for RLum S4 class objects}
\usage{
set_RLum(class, originator, .uid = create_UID(), .pid = NA_character_, ...)
}
\arguments{
\item{class}{\link{character} (\strong{required}):
name of the S4 class to create, must correspond to one of the \linkS4class{RLum}
classes.}

\item{originator}{\link{character} (\emph{automatic}):
contains the name of the calling function (the function that produces this object);
can be set manually.}

\item{.uid}{\link{character} (\emph{automatic}):
unique ID for this object, by default set using the internal C++ function
\code{create_UID}.}

\item{.pid}{\link{character} (\emph{with default}):
option to provide a parent id for nesting at will.}

\item{...}{further arguments passed to the specific class method}
}
\value{
An object of the specified \linkS4class{RLum} class.
}
\description{
The function provides a generalised access point for specific
\linkS4class{RLum} objects. Depending on the given class, the corresponding
method to create an object from this class will be selected.
Allowed additional arguments can be found in the documentations of the
corresponding \linkS4class{RLum} class:
\itemize{
\item \linkS4class{RLum.Data.Curve},
\item \linkS4class{RLum.Data.Image},
\item \linkS4class{RLum.Data.Spectrum},
\item \linkS4class{RLum.Analysis},
\item \linkS4class{RLum.Results}
}
}
\section{Function version}{
 0.3.0
}

\examples{

## produce empty objects from each class
set_RLum(class = "RLum.Data.Curve")
set_RLum(class = "RLum.Data.Spectrum")
set_RLum(class = "RLum.Data.Spectrum")
set_RLum(class = "RLum.Analysis")
set_RLum(class = "RLum.Results")

## produce a curve object with arbitrary curve values
object <- set_RLum(
class = "RLum.Data.Curve",
curveType = "arbitrary",
recordType = "OSL",
data = matrix(c(1:100,exp(-c(1:100))),ncol = 2))

## plot this curve object
plot_RLum(object)

}
\seealso{
\linkS4class{RLum.Data.Curve}, \linkS4class{RLum.Data.Image},
\linkS4class{RLum.Data.Spectrum}, \linkS4class{RLum.Analysis}, \linkS4class{RLum.Results}
}
\author{
Sebastian Kreutzer, Institute of Geography, Heidelberg University (Germany)
, RLum Developer Team} 

\section{How to cite}{
Kreutzer, S., 2025. set_RLum(): General setter function for RLum S4 class objects. Function version 0.3.0. In: Kreutzer, S., Burow, C., Dietze, M., Fuchs, M.C., Schmidt, C., Fischer, M., Friedrich, J., Mercier, N., Philippe, A., Riedesel, S., Autzen, M., Mittelstrass, D., Gray, H.J., Galharret, J., Colombo, M., Steinbuch, L., Boer, A.d., 2025. Luminescence: Comprehensive Luminescence Dating Data Analysis. R package version 1.1.0. https://r-lum.github.io/Luminescence/
}

\keyword{utilities}
