% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VARFIMA_sim.R
\name{VARFIMA.sim}
\alias{VARFIMA.sim}
\title{Simulation of a VARFIMA(1,1) in final equations form.}
\usage{
VARFIMA.sim(phi, THETA, d.vec, T, Sigma, approx = 100, burnin = 100)
}
\arguments{
\item{phi}{AR(1)-parameter.}

\item{THETA}{MA(1)-matrix.}

\item{d.vec}{vector of memory parameters.}

\item{T}{desired sample size.}

\item{Sigma}{Variance-Covariance-Matrix of the innovations.}

\item{approx}{order of the AR-approximation that is supposed to be used. Default is \code{approx=100}.}

\item{burnin}{length of the burnin period that is discarded. Default is \code{burnin=100}.}
}
\description{
\code{VARFIMA.sim} returns a sample from a VARFIMA(1,1)-process.
}
\details{
add details here.
}
\examples{
series<-VARFIMA.sim(phi=0.4, THETA=matrix(c(0,0,0,0),2,2), 
d.vec=c(0.4,0.3), T=1000, Sigma=matrix(c(1,0.4,0.4,1),2,2))
ts.plot(series, col=1:2)
acf(series, lag=100)
}
\references{
Lutkepohl, H. (2007): New introduction to multiple time series analysis. Springer.
}
