% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/N10_LM.R
\name{FCI_N10}
\alias{FCI_N10}
\title{Nonparametric test for fractional cointegration (Nielsen (2010))}
\usage{
FCI_N10(X, d1 = 0.1, m, mean_correct = c("mean", "init", "weighted",
  "none"), type = c("test", "rank"), alpha = 0.05)
}
\arguments{
\item{X}{data matrix.}

\item{d1}{fixed order of integration, default is \code{d1=0.1} as recommended by Nielsen (2010), no critical values for other choices available.}

\item{m}{bandwith parameter specifying the number of Fourier frequencies
used for the memory estimation required for the asymptotic distribution, usually \code{floor(1+T^delta)}, where 0<delta<1.}

\item{mean_correct}{specifies the form of mean correction in the memory estimation.}

\item{type}{string that determines whether the test or the rank estimation procedure is applied.}

\item{alpha}{desired significance level. Default is \code{alpha=0.05}.}
}
\description{
\code{FCI_CH06} Nonparametric test and rank estimation for fractional cointegration by Nielson (2010).
 Returns either test statistic, critical value and testing decision (null hypothesis: no fractional cointegration) or the estimated cointegrating rank.
}
\examples{
T<-1000
series<-FI.sim(T=T, q=2, rho=0.4, d=c(0.1,0.9), B=rbind(c(1,-1),c(0,1)))
FCI_N10(series, m=floor(T^0.75), type="test")
series<-FI.sim(T=T, q=2, rho=0.4, d=c(0.9,0.9))
FCI_N10(series, m=floor(T^0.75), type="test")
series<-FI.sim(T=T, q=3, rho=0.4, d=c(0.2,0.2,1), B=rbind(c(1,-0.5,-0.3),c(0,1,-0.4),c(0,0,1)))
FCI_N10(series,m=floor(T^0.75),type="rank")
}
\references{
Nielsen, M. O. (2010): Nonparametric cointegration analysis of fractional systems with unknown integration orders.
Journal of Econometrics, Vol. 155, No. 2, pp. 170 - 187.
}
\author{
Christian Leschinski, Michelle Voges
}
