% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LLM_robust_utils.R
\name{log_llm_error}
\alias{log_llm_error}
\title{Log LLMR Errors}
\usage{
log_llm_error(err)
}
\arguments{
\item{err}{An error object.}
}
\value{
Invisibly returns \code{NULL}.
}
\description{
Logs an error with a timestamp for troubleshooting.
}
\examples{
\dontrun{
  # Example of logging an error by catching a failure:
  # Use a deliberately fake API key to force an error
  config_test <- llm_config(
    provider = "openai",
    model = "gpt-3.5-turbo",
    api_key = "FAKE_KEY",
    temperature = 0.5,
    top_p = 1,
    max_tokens = 30
  )

  tryCatch(
    call_llm(config_test, list(list(role = "user", content = "Hello world!"))),
    error = function(e) log_llm_error(e)
  )
}
}
