% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/JATS_get.abstract.R
\name{get.abstract}
\alias{get.abstract}
\title{get.abstract}
\usage{
get.abstract(
  x,
  sentences = FALSE,
  remove.title = TRUE,
  letter.convert = TRUE,
  cermine = FALSE
)
}
\arguments{
\item{x}{a NISO-JATS coded XML file or text.}

\item{sentences}{Logical. If TRUE abstract is returned as vector of sentences.}

\item{remove.title}{Logical. If TRUE removes section titles in abstract.}

\item{letter.convert}{Logical. If TRUE converts hexadecimal and HTML coded characters to Unicode.}

\item{cermine}{Logical. If TRUE and if 'letter.convert=TRUE' CERMINE specific letter correction is carried out (e.g. inserting of missing operators to statistical results).}
}
\value{
Character. The abstract/s text as floating text or vector of sentences.
}
\description{
Extracts abstract tag from NISO-JATS coded XML file or text as vector of abstracts.
}
\examples{
x<-"Some text <abstract>Some abstract</abstract> some text"
get.abstract(x)
x<-"Some text <abstract>Some abstract</abstract> TEXT <abstract with subsettings>
Some other abstract</abstract> Some text "
get.abstract(x)
}
\seealso{
\code{\link[JATSdecoder]{JATSdecoder}} for simultaneous extraction of meta-tags, abstract, sectioned text and reference list.
}
