% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{summary.IssueTB}
\alias{summary.IssueTB}
\alias{summary.IssuesTB}
\title{Compute a summary of an issue or a list of issues}
\usage{
\method{summary}{IssueTB}(object, ...)

\method{summary}{IssuesTB}(object, ...)
}
\arguments{
\item{object}{a \code{IssueTB} or \code{IssuesTB} object.}

\item{\dots}{Unused argument}
}
\value{
invisibly (with \code{invisible()}) \code{NULL}.
}
\description{
Compute a summary of an issue or a list of issues
}
\details{
This function compute the summary of an issue (\code{IssueTB} object) with
adding some information (number of comments, ...).
For a list of issues (\code{IssuesTB} object), it just summarise the
information with statistics by modalities.
}
\examples{
all_issues <- get_issues(
    source = "local",
    dataset_dir = system.file("data_issues", package = "IssueTrackeR"),
    dataset_name = "list_issues.yaml"
)

# Summarise one issue
summary(all_issues[1, ])

# Summarise several issues
summary(all_issues[1:10, ])
}
