% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_issues.R
\name{filter_issues}
\alias{filter_issues}
\alias{filter_issues.IssuesTB}
\alias{filter_issues.default}
\title{Filter issue or issues}
\usage{
filter_issues(x, ...)

\method{filter_issues}{IssuesTB}(x, ...)

\method{filter_issues}{default}(x, ...)
}
\arguments{
\item{x}{a \code{IssuesTB} object.}

\item{\dots}{Other options used to control filtering behaviour with different
fields and values. Passed on to \code{\link[IssueTrackeR]{contains}} as:
\itemize{
\item \code{values}: a vector \code{string}. Patterns to look for in the outcome.
\item \code{fields}: a vector \code{string}. The different fields of the issue in
which to search for the pattern (among \code{"title"}, \code{"body"},
\code{"labels"} and \code{"milestone"})
\item \code{fields_logic_gate}: the logic operator which will aggregate the
different assertion related to fields: \code{"OR"} (by default) or
\code{"AND"}.
\item \code{values_logic_gate}: the logic operator which will aggregate the
different assertion related to values: \code{"OR"} or \code{"AND"} (by
default).
\item \code{negate}: a boolean indicate the negation of the assertion.
}}
}
\value{
a \code{IssuesTB} object filtered
}
\description{
Filtering issues with some constraint on the labels, the title and the body.
}
\details{
This function relies on the function \code{\link[IssueTrackeR]{contains}}.
More informations on the filtering in the documentation of the function
\code{\link[IssueTrackeR]{contains}}.
}
\examples{

\donttest{
all_issues <- get_issues(source = "online", verbose = FALSE)
# Condition: issues containing "README" in its body OR title
filtered_issues <- filter_issues(
    x = all_issues,
    fields = c("body", "title"),
    values = "README",
    fields_logic_gate = "OR"
)

# Condition: issues containing neither "unknown" nor "medium" in their label
filtered_issues <- filter_issues(
    x = all_issues,
    fields = "labels",
    values = c("unknown", "medium"),
    values_logic_gate = "OR",
    negate = TRUE,
    fields_logic_gate = "AND"
)
}

}
