% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ImHD.R
\name{ImHD}
\alias{ImHD}
\title{Artificial Intelligence Based Machine Learning Algorithms for Height Diameter Relationships of Conifer Trees}
\usage{
ImHD(data, splitratio = 0.7)
}
\arguments{
\item{data}{Datasets}

\item{splitratio}{Train-Test split ratio}
}
\value{
\itemize{
  \item Prediction: Prediction of all ML models
  \item Accuracy:  Accuracy metrics
}
}
\description{
Artificial Intelligence Based Machine Learning Algorithms for Height Diameter Relationships of Conifer Trees
}
\examples{
\donttest{
library("ImHD")
data <- system.file("extdata", "data_test.csv", package = "ImHD")
data_test <- read.csv(data)
Model<-ImHD(data =data_test)
}
}
\references{
\itemize{
\item Jeelani, M.I., Tabassum, A., Rather, K and Gul,M.2023. Neural Network Modeling of Height Diameter Relationships for Himalayan Pine through Back Propagation Approach. Journal of The Indian Society of Agricultural Statistics. 76(3): 169–178.  <doi:10.1002/9781118032985>
}
}
