% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_net.R
\name{build_net}
\alias{build_net}
\title{Generating tripartite network}
\usage{
build_net(lay_0, lay_1, lay_2, C_lay, asmatrices = FALSE)
}
\arguments{
\item{lay_0}{The number of nodes in the first layer.}

\item{lay_1}{The number of nodes in the second layer.}

\item{lay_2}{The number of nodes in the third layer.}

\item{C_lay}{The probability of each node interact with the other one. It ranges from 0 to 1.}

\item{asmatrices}{Logical. whether to output the overall adjacency matrix of the network and the corresponding interaction matrix of the respective subnetworks. Defaults to FALSE.}
}
\value{
Return a tripatite network of direction. The network contains three groups of species and interactions within layers, and there is no link among each group of nodes within one layer.
}
\description{
Generating a network of three layers. All layers of network contain \code{lay_0}, \code{lay_1} and \code{lay_2} nodes respectively.
}
\examples{

set.seed(12)
d <- build_net(11,15,16,0.2)
plot(d)

set.seed(12)
N <- build_net(11,15,16,0.2,asmatrices=FALSE)
N

}
