% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcmc_plots.R
\name{mcmc_plots}
\alias{mcmc_plots}
\title{Consolidated MCMC Plots Function}
\usage{
mcmc_plots(
  simulation_results,
  centroid_data,
  centroid_2d_points,
  actual_data,
  state_time_data,
  forecast_type,
  n_ahead_ante,
  type,
  raw_dataset,
  show_simulation,
  mae_metric = mae_metric,
  time_column,
  trainHVT_results
)
}
\arguments{
\item{simulation_results}{Data frame with simulation results}

\item{centroid_data}{Data frame with centroid information}

\item{centroid_2d_points}{Data frame with 2D coordinates}

\item{actual_data}{Data frame with actual values}

\item{state_time_data}{Data frame with state-time information}

\item{forecast_type}{Type of forecast ("ex-post" or "ex-ante")}

\item{n_ahead_ante}{Number of ahead steps for ex-ante}

\item{type}{Plot type identifier}

\item{raw_dataset}{Raw dataset for scaling}

\item{show_simulation}{Whether to show simulation lines}

\item{mae_metric}{MAE metric to use}

\item{time_column}{Name of time column}

\item{trainHVT_results}{HVT training results}
}
\value{
List containing all plots and data frames
}
\description{
Creates comprehensive plots for HVT-MSM simulation results with minimal code duplication.
}
\author{
Vishwavani <vishwavani@mu-sigma.com>
}
\keyword{internal}
