% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{summary}
\alias{summary}
\title{Table for displaying summary}
\usage{
summary(data, limit = 20, scroll = TRUE)
}
\arguments{
\item{data}{List. A listed object from trainHVT or scoreHVT}

\item{limit}{Numeric. A value to indicate how many rows to display.}

\item{scroll}{Logical. A value to indicate whether to display scroll bar or not. Default value is TRUE.}
}
\value{
A consolidated table of summary for training, scoring and forecasting
}
\description{
This is the main function for displaying summary from model training and scoring
}
\examples{
data <- datasets::EuStockMarkets
dataset <- as.data.frame(data)
#model training
hvt.results <- trainHVT(dataset, n_cells = 60, depth = 1, quant.err = 0.1,
                      distance_metric = "L1_Norm", error_metric = "max",
                      normalize = TRUE, quant_method = "kmeans", dim_reduction_method = 'sammon')
summary(data =  hvt.results)
}
\author{
Vishwavani <vishwavani@mu-sigma.com>, Alimpan Dey <alimpan.dey@mu-sigma.com>
}
\keyword{Table_Formatting}
