% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scoreLayeredHVT.R
\name{scoreLayeredHVT}
\alias{scoreLayeredHVT}
\title{Score which cell and what layer each data point in the test dataset belongs to}
\usage{
scoreLayeredHVT(
  data,
  hvt_mapA,
  hvt_mapB,
  hvt_mapC,
  mad.threshold = 0.2,
  normalize = TRUE,
  seed = 300,
  distance_metric = "L1_Norm",
  error_metric = "max",
  child.level = 1,
  yVar = NULL
)
}
\arguments{
\item{data}{Data Frame. A data frame containing test dataset. 
The data frame should have all the variable(features) used for training.}

\item{hvt_mapA}{A list of hvt.results.model obtained from trainHVT function while performing
`trainHVT()` on train data}

\item{hvt_mapB}{A list of hvt.results.model obtained from trainHVT function while performing 
`trainHVT()` on data with novelty(s)}

\item{hvt_mapC}{A list of hvt.results.model obtained from trainHVT function while performing
`trainHVT()` on data without novelty(s)}

\item{mad.threshold}{Numeric. A number indicating the permissible Mean Absolute Deviation}

\item{normalize}{Logical. A logical value indicating if the dataset should be normalized. 
When set to TRUE, the data (testing dataset) is standardized by 'mean' and 'sd' of the training dataset 
referred from the trainHVT(). When set to FALSE, the data is used as such without any changes.
(Default value is TRUE).}

\item{seed}{Numeric. Random Seed.}

\item{distance_metric}{Character. The distance metric can be L1_Norm(Manhattan) or L2_Norm(Eucledian). L1_Norm is selected by default.
The distance metric is used to calculate the distance between an n dimensional point and centroid.
The distance metric can be different from the one used during training.}

\item{error_metric}{Character. The error metric can be mean or max. max is selected by default. 
max will return the max of m values and mean will take mean of m values where
each value is a distance between a point and centroid of the cell.}

\item{child.level}{Numeric. A number indicating the level for which the heat map is to be plotted.}

\item{yVar}{Character. A character or a vector representing the name of the dependent variable(s)}
}
\value{
Dataframe containing scored layer output
}
\description{
This function that scores the cell and corresponding layer for each data point in a test dataset using three 
hierarchical vector quantization (HVT) models (Map A, Map B, Map C) and returns a data frame containing the scored layer output. 
The function incorporates the scored results from each map and merges them to provide a comprehensive result.
}
\examples{
data("EuStockMarkets")
dataset <- data.frame(date = as.numeric(time(EuStockMarkets)),
                     DAX = EuStockMarkets[, "DAX"],
                     SMI = EuStockMarkets[, "SMI"],
                     CAC = EuStockMarkets[, "CAC"],
                     FTSE = EuStockMarkets[, "FTSE"])
rownames(EuStockMarkets) <- dataset$date

train <- EuStockMarkets[1:1302, ]
test <- EuStockMarkets[1303:1860, ]

###MAP-A
hvt_mapA <- trainHVT(train, n_cells = 150, depth = 1, quant.err = 0.1,
                    distance_metric = "L1_Norm", error_metric = "max",
                    normalize = TRUE,quant_method = "kmeans")
                    
identified_Novelty_cells <- c(127,55,83,61,44,35,27,77)
output_list <- removeNovelty(identified_Novelty_cells, hvt_mapA)
data_with_novelty <- output_list[[1]] 
data_with_novelty <- data_with_novelty[, -c(1,2)]

### MAP-B
hvt_mapB <- trainHVT(data_with_novelty,n_cells = 10, depth = 1, quant.err = 0.1,
                    distance_metric = "L1_Norm", error_metric = "max",
                    normalize = TRUE,quant_method = "kmeans")
data_without_novelty <- output_list[[2]]

### MAP-C
hvt_mapC <- trainHVT(data_without_novelty,n_cells = 135,
                    depth = 1, quant.err = 0.1, distance_metric = "L1_Norm",
                    error_metric = "max", quant_method = "kmeans",
                    normalize = TRUE)
                    
##SCORE LAYERED
data_scored <- scoreLayeredHVT(test, hvt_mapA, hvt_mapB, hvt_mapC)
}
\seealso{
\code{\link{trainHVT}} \cr \code{\link{plotHVT}}
}
\author{
Shubhra Prakash <shubhra.prakash@mu-sigma.com>, Sangeet Moy Das <sangeet.das@mu-sigma.com>, Shantanu Vaidya <shantanu.vaidya@mu-sigma.com>,Somya Shambhawi <somya.shambhawi@mu-sigma.com>
}
\keyword{Scoring}
