% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotStateTransition.R
\name{plotStateTransition}
\alias{plotStateTransition}
\title{Creating State Transition Plot}
\usage{
plotStateTransition(
  df,
  sample_size = NULL,
  line_plot = NULL,
  cellid_column,
  time_column,
  v_intercept = NULL,
  time_periods = NULL
)
}
\arguments{
\item{df}{Data frame. The Input data frame should contain two columns. 
Cell ID from scoreHVT function and time stamp of that dataset.}

\item{sample_size}{Numeric. An integer indicating the fraction of the data frame to visualize in the plot.
Default value is 0.2}

\item{line_plot}{Logical. A logical value indicating to create a line plot. Default value is NULL.}

\item{cellid_column}{Character. Name of the column containing cell IDs.}

\item{time_column}{Character. Name of the column containing time stamps.}

\item{v_intercept}{Numeric. A numeric value indicating the time stamp to draw a vertical line on the plot.}

\item{time_periods}{List. A list of vectors, each containing start and end times for highlighting time periods.}
}
\value{
A plotly object representing the state transition plot for the given data frame.
}
\description{
This is the main function to create a state transition plot from a data frame.
A state transition plot is a type of data visualization used to represent 
the changes or transitions in states over time for a given system. 
State refers to a particular condition or status of a cell at a specific point in time. 
Transition refers to the change of state for a cell from one condition to another over time.
}
\examples{
dataset <- data.frame(date = as.numeric(time(EuStockMarkets)),
DAX = EuStockMarkets[, "DAX"],
SMI = EuStockMarkets[, "SMI"],
CAC = EuStockMarkets[, "CAC"],
FTSE = EuStockMarkets[, "FTSE"])

hvt.results<- trainHVT(dataset,n_cells = 60, depth = 1, quant.err = 0.1,
                       distance_metric = "L1_Norm", error_metric = "max",
                       normalize = TRUE,quant_method = "kmeans")
scoring <- scoreHVT(dataset, hvt.results)
cell_id <- scoring$scoredPredictedData$Cell.ID
time_stamp <- dataset$date
dataset <- data.frame(cell_id, time_stamp)
plotStateTransition(dataset, sample_size = 1, cellid_column = "cell_id",time_column = "time_stamp")
}
\author{
PonAnuReka Seenivasan <ponanureka.s@mu-sigma.com>, Vishwavani <vishwavani@mu-sigma.com>
}
\keyword{Timeseries_Analysis}
