% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GLStoUNI.R
\name{multiGLStoUNI}
\alias{multiGLStoUNI}
\title{Translate Multiple GL Strings to UNIFORMAT}
\usage{
multiGLStoUNI(GLstringArray, prefix = "HLA-", pre = FALSE)
}
\arguments{
\item{GLstringArray}{A data frame or a vector containing GL String formatted data. If 'GLstringArray' is a data frame with more than one column, the first column should contain only identifiers. If 'GLstringArray' is a vector, it should contain only GL Strings.}

\item{prefix}{A string of the desired locus prefix (default is "HLA-").}

\item{pre}{A logical. If 'pre' is TRUE, all allele names will be prefixed with 'prefix'. If 'pre' is FALSE, no allele names will be prefixed.}
}
\value{
A version of 'GLStringArray' in which the GL String data has been converted to UNIFORMAT format. If a 'GLstringArray' was a data frame, a data frame is returned. If 'GLstringArray' was a vector, a vector is returned.
}
\description{
Translate a data frame or a vector of GL Strings to UNIFORMAT strings.
}
\note{
GL Strings that include the "?" operator will not be translated, as the "?" operator has no cognate in UNIFORMAT.
}
\examples{
multiGLStoUNI(GLstring.ex[[2]][1:5],version) ## converting a vector of GL Strings to UNIFORMAT
multiGLStoUNI(GLstring.ex[1:5,1:2])  ## converting a data.frame of GL Strings to UNIFORMAT

}
\references{
Nunes Tissue Antigens 2007;69(s1):203-205 https://doi.org/10.1111/j.1399-0039.2006.00808.x

Mack et al. HLA 2023;102(2):206-212 https://doi.org/10.1111/tan.15126
}
