% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getDescriptionStatsBy_prAddTotalDescColumn.R
\name{prAddTotalDescColumn}
\alias{prAddTotalDescColumn}
\title{Add a total column to the results}
\usage{
prAddTotalDescColumn(
  results,
  x,
  by,
  numbers_first,
  total_col_show_perc,
  show_all_values,
  useNA,
  useNA.digits,
  html,
  digits,
  continuous_fn,
  factor_fn,
  prop_fn,
  percentage_sign,
  default_ref,
  header_count = NULL,
  add_total_col
)
}
\arguments{
\item{results}{The results that we want to add the column to}

\item{x}{If a data.frame it will be used as the data source for the variables in the \code{...} parameter.
If it is a single variable it will be the core value that want the statistics for.
In the print this is equivalent to the output of this function.}

\item{by}{The variable that you want to split into different columns}

\item{numbers_first}{If the number should be given or if the percentage
should be presented first. The second is encapsulated in parentheses ().}

\item{total_col_show_perc}{This is by default true but if
requested the percentages are suppressed as this sometimes may be confusing.}

\item{show_all_values}{Show all values in proportions. For factors with only two values
it is most sane to only show one option as the other one will just be a complement
to the first, i.e. we want to convey a proportion. For instance sex - if you know
gender then automatically you know the distribution of the other sex as it's 100 \% - other \%.
To choose which one you want to show then set the \code{default_ref} parameter.}

\item{useNA}{This indicates if missing should be added as a separate
row below all other. See \code{\link[base]{table}} for \code{useNA}-options.
\emph{Note:} defaults to ifany and not "no" as \code{\link[base]{table}} does.}

\item{useNA.digits}{The number of digits to use for the
missing percentage, defaults to the overall \code{digits}.}

\item{html}{If HTML compatible output should be used. If \code{FALSE}
it outputs LaTeX formatting}

\item{digits}{The number of decimals used}

\item{continuous_fn}{The method to describe continuous variables. The
default is \code{\link{describeMean}}.}

\item{factor_fn}{The method used to describe factors, see \code{\link{describeFactors}}.}

\item{prop_fn}{The method used to describe proportions, see \code{\link{describeProp}}.}

\item{percentage_sign}{If you want to suppress the percentage sign you
can set this variable to FALSE. You can also choose something else that
the default \% if you so wish by setting this variable.}

\item{default_ref}{The default reference when dealing with proportions. When using
`dplyr` syntax (`tidyselect`) you can specify a named vector/list for each column name.}

\item{header_count}{Set to \code{TRUE} if you want to add a header count,
e.g. Smoking; No. 25 observations, where there is a new line after the
factor name. If you want a different text for the second line you can
specifically use the \code{\link[base]{sprintf}} formatting, e.g. "No. \%s patients".}

\item{add_total_col}{This adds a total column to the resulting table.
You can also specify if you want the total column "first" or "last"
in the column order.}
}
\value{
results with added column
}
\description{
Add a total column to the results
}
