## ---- include = FALSE---------------------------------------------------------
knitr::opts_chunk$set(
  eval = T,
  collapse = TRUE,
  out.width = "50%",
  fig.width = 7,
  comment = "#>"
)

## ----setup--------------------------------------------------------------------
library(GRShiny)

## -----------------------------------------------------------------------------
item_pars <- genIRTpar(nitem = 10, ncat = 3, nfac = 1)

## -----------------------------------------------------------------------------
true_theta <- genTheta(nsample = 500, nfac = 1)

## -----------------------------------------------------------------------------
grm_dt <- genData(eta = true_theta, ipar = item_pars)

## -----------------------------------------------------------------------------
lav_syn <- genLavSyn(dat = grm_dt, nfac = 1)

## -----------------------------------------------------------------------------
grm.fit <- runGRM(dat = grm_dt, lav.syntax = lav_syn, estimator = "WL")

## -----------------------------------------------------------------------------
extract_est(grm.fit)

## -----------------------------------------------------------------------------
ICCplot(grm.fit, 1)
ESplot(grm.fit , 1)
infoPlot(grm.fit, 1)
FSplot(grm.fit)

## ----eval = F-----------------------------------------------------------------
#  startGRshiny()

