% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formula.R
\name{handleFormula}
\alias{handleFormula}
\title{handle a formula (used in GRAB.NullModel function)}
\usage{
handleFormula(formula, data, subset, subjData)
}
\arguments{
\item{formula}{a formula object, with the response on the left of a ~ operator and the covariates on the right. Do not add a column of intercept (e.g. a vector of ones) on the right. Missing values should be denoted by NA and the corresponding samples will be removed from analysis.}

\item{data}{a data.frame in which to interpret the variables named in the formula, or in the subset argument. Check ?model.frame for more details.}

\item{subset}{a specification of the rows to be used: defaults to all rows. This can be any valid indexing vector for the rows of data or if that is not supplied, a data frame made up of the variables used in formula. Check ?model.frame for more details.}

\item{subjData}{a character vector of subject IDs. Its order should be the same as the subjects order in the formula and data.}
}
\value{
an R list with elements of 'response', 'designMat', and 'subjData'.
}
\description{
handle a formula (used in GRAB.NullModel function), this function can help users better understand the input of GRAB.NullModel() function
}
\examples{
n <- 20
subjData <- paste0("ID-", 1:n)
pheno <- rbinom(n, 1, 0.5)
x1 <- rnorm(n)
x2 <- rnorm(n)
x3 <- rbinom(n, 2, 0.5)
objFormula <- handleFormula(pheno ~ x1 + x2 * x3, subset = x2 > 0, subjData = subjData)
objFormula
}
