% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SparseGRM.R
\name{getTempFilesFullGRM}
\alias{getTempFilesFullGRM}
\title{Make temporary files to be passed to function \code{\link{getSparseGRM}}.}
\usage{
getTempFilesFullGRM(
  PlinkFile,
  nPartsGRM,
  partParallel,
  gcta64File,
  tempDir = NULL,
  subjData = NULL,
  minMafGRM = 0.01,
  maxMissingGRM = 0.1,
  threadNum = 8
)
}
\arguments{
\item{PlinkFile}{a path to PLINK files (without file extensions of bed/bim/fam). Note that the current version (gcta_1.93.1beta) of gcta software does not support different prefix names for bim, bed, and fam files.}

\item{nPartsGRM}{a numeric value (e.g. 250): \code{GCTA} software can split subjects to multiple parts. For UK Biobank data analysis, it is recommended to set \code{nPartsGRM=250}.}

\item{partParallel}{a numeric value (from 1 to \code{nPartsGRM}) to split all jobs for parallel computation.}

\item{gcta64File}{a path to \code{GCTA} program. GCTA can be downloaded from \href{https://yanglab.westlake.edu.cn/software/gcta/#Download}{link}.}

\item{tempDir}{a path to store temp files to be passed to \code{\link{getSparseGRM}}. This should be consistent to the input of \code{\link{getSparseGRM}}. Default is system.file("SparseGRM", "temp", package = "GRAB").}

\item{subjData}{a character vector to specify subject IDs to retain (i.e. IID). Default is \code{NULL}, i.e. all subjects are retained in sparse GRM. If the number of subjects is less than 1,000, the GRM estimation might not be accurate.}

\item{minMafGRM}{Minimal value of MAF cutoff to select markers (from PLINK files) to make sparse GRM. \emph{(default=0.01)}}

\item{maxMissingGRM}{Maximal value of missing rate to select markers (from PLINK files) to make sparse GRM. \emph{(default=0.1)}}

\item{threadNum}{Number of threads (CPUs) to use.}
}
\value{
A character string message indicating the completion status and location of the temporary files.
}
\description{
Make temporary files to be passed to function \code{\link{getSparseGRM}}. We strongly suggest using parallel computing for different \code{partParallel}.
}
\details{
\itemize{
\item \code{Step 1}: Run \code{getTempFilesFullGRM} to get temporary files.
\item \code{Step 2}: Run \code{\link{getSparseGRM}} to combine the temporary files to make a \code{SparseGRMFile} to be passed to \code{\link{GRAB.NullModel}}.
}
}
\examples{
## Please check help(getSparseGRM) for an example.
}
