% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Fuzzy_sample_variance_17102018.R
\name{Fuzzy.variance}
\alias{Fuzzy.variance}
\title{Calculates the variance by a chosen method: distance, exact or approximation}
\usage{
Fuzzy.variance(
  data.fuzzified,
  method,
  dist.type = "DSGD",
  i = 1,
  j = 1,
  theta = 1/3,
  thetas = 1,
  p = 2,
  q = 0.5,
  breakpoints = 100,
  int.method = "int.simpson",
  plot = FALSE
)
}
\arguments{
\item{data.fuzzified}{a fuzzification matrix constructed by a call to the function FUZZ or the function GFUZZ, 
or a similar matrix. No NA are allowed.}

\item{method}{choices are the following: "distance", "exact", "approximation1", "approxi- mation2", "approximation3", "approximation4", "approximation5".}

\item{dist.type}{type of distance chosen from the family of distances. The different choices are given by: "Rho1", "Rho2", "Bertoluzza", "Rhop", "Delta.pq", "Mid/Spr", "wabl", "DSGD", "DSGD.G", "GSGD".}

\item{i}{parameter of the density function of the Beta distribution, fixed by default to i = 1.}

\item{j}{parameter of the density function of the Beta distribution, fixed by default to j = 1.}

\item{theta}{a numerical value between 0 and 1, representing a weighting parameter. By default, theta is fixed to 1/3 referring to the Lebesgue space. This measure is used in the calculations of the following distances: d_Bertoluzza, d_mid/spr and d_phi-wabl/ldev/rdev.}

\item{thetas}{a decimal value between 0 and 1, representing the weight given to the shape of the fuzzy number. By default, thetas is fixed to 1. This parameter is used in the calculations of the d_theta star and the d_GSGD distances.}

\item{p}{a positive integer such that 1 \eqn{\le} p < infinity, referring to the parameter of the Rho_p and Delta_pq. By default, p is fixed to 2.}

\item{q}{a decimal value between 0 and 1, referring to the parameter of the metric Delta_pq. By default, q is fixed to 0.5.}

\item{breakpoints}{a positive arbitrary integer representing the number of breaks chosen to build the numerical alpha-cuts. It is fixed to 100 by default.}

\item{int.method}{the integration method could be one of the following four methods: "int.0", "int.t", "int.ct" and "int.simpson".}

\item{plot}{fixed by default to "FALSE". plot="TRUE" if a plot of the fuzzy number is required.}
}
\value{
If the parameter method = "distance", returns a numerical value. If else, returns the numerical \eqn{\alpha}-cuts of the estimated fuzzy variance.
}
\description{
Calculates the variance by a chosen method: distance, exact or approximation
}
\examples{
data <- matrix(c(1,2,3,2,2,1,1,3,1,2),ncol=1) 
MF111 <- TrapezoidalFuzzyNumber(0,1,1,2) 
MF112 <- TrapezoidalFuzzyNumber(1,2,2,3) 
MF113 <- TrapezoidalFuzzyNumber(2,3,3,3) 
PA11 <- c(1,2,3) 
data.fuzzified <- FUZZ(data,mi=1,si=1,PA=PA11) 
Fuzzy.variance(data.fuzzified, method = "approximation5", plot=TRUE) 
Fuzzy.variance(data.fuzzified, method = "distance")
}
