% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FTukeyHSD_20200302.R
\name{Ftests}
\alias{Ftests}
\title{Calculates multiple tests corresponding to the fuzzy response variable}
\usage{
Ftests(test)
}
\arguments{
\item{test}{a result of a call of the function FMANOVA.}
}
\value{
Returns a table of the following different indicators "Wilks","F-Wilks", "Hotelling-Lawley trace" and "Pillai Trace".
}
\description{
Calculates multiple tests corresponding to the fuzzy response variable
}
\examples{
mat <- matrix(c(2,2,1,1,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,2,3,4,4,3,1,2,5,4,4,3),ncol=3)
data <- data.frame(mat)
MF131 <- TrapezoidalFuzzyNumber(0,1,1,2)
MF132 <- TrapezoidalFuzzyNumber(1,2,2,3)
MF133 <- TrapezoidalFuzzyNumber(2,3,3,4)
MF134 <- TrapezoidalFuzzyNumber(3,4,4,5)
MF135 <- TrapezoidalFuzzyNumber(4,5,5,6)
PA13 <- c(1,2,3,4,5); mi <- 1; si <- 3
Yfuzz <- FUZZ(data,1,3,PA13)
attach(data)
formula <- X3 ~ X1 + X2
res <- FMANOVA(formula, data, Yfuzz, method = "distance", distance.type = "wabl")
Ftests(res)
detach(data)
}
