% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FMANOVA_Approximation_20122018.R
\name{FMANOVA.approximation}
\alias{FMANOVA.approximation}
\title{Computes a Mult-FANOVA model by an approximation}
\usage{
FMANOVA.approximation(
  formula,
  dataset,
  data.fuzzified,
  sig = 0.05,
  breakpoints = 100,
  index.var = NA,
  int.method = "int.simpson",
  plot = TRUE
)
}
\arguments{
\item{formula}{a description of the model to be fitted.}

\item{dataset}{the data frame containing all the variables of the model.}

\item{data.fuzzified}{the fuzzified data set constructed by a call to the function FUZZ or the function GFUZZ, or a similar matrix.}

\item{sig}{a numerical value representing the significance level of the test.}

\item{breakpoints}{a positive arbitrary integer representing the number of breaks chosen to build the numerical alpha-cuts. It is fixed to 100 by default.}

\item{index.var}{the column index of the considered variable for which the output will be printed. It is an argument of the Mult-FANOVA models by the exact and the approximation methods only.}

\item{int.method}{the method of numerical integration. It is set by default to the Simpson method, i.e. int.method="int.simpson".}

\item{plot}{fixed by default to "TRUE". plot="FALSE" if a plot of the fuzzy number is not required.}
}
\value{
Returns a list of all the arguments of the function, the total, treatment and residuals sums of squares, the coefficients of the model, the test statistics with the corresponding p-values, and the decision made.
}
\description{
Computes a Mult-FANOVA model by an approximation
}
