% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recombination_pbest.R
\name{recombination_pbest}
\alias{recombination_pbest}
\title{p-Best recombination for DE}
\usage{
recombination_pbest(X, M, recpars)
}
\arguments{
\item{X}{population matrix (original)}

\item{M}{population matrix (mutated)}

\item{recpars}{recombination parameters (see \code{Recombination parameters} 
for details)}
}
\value{
Matrix \code{U} containing the recombined population
}
\description{
Implements the "/pbest" (p-Best) recombination for the ExpDE framework
}
\section{Recombination Parameters}{

The \code{recpars} parameter contains all parameters required to define the 
recombination. \code{recombination_pbest()} understands the following 
fields in \code{recpars}:
\itemize{
   \item \code{cr} : component-wise probability of using the value in 
                     \code{M}.\cr
                     Accepts numeric value \code{0 < cr <= 1}.
}
}

\section{Warning}{

This routine will search for the iterations counter (\code{t}), the maximum 
number of iterations (\code{stopcrit$maxiter}), and the performance vector 
of population \code{X} (\code{J}) in the parent environment (using 
\code{parent.frame()}. These variables must be defined for 
\code{recombination_pbest()} to work.
}

\section{References}{

S.M. Islam, S. Das, S. Ghosh, S. Roy, P.N. Suganthan, "An Adaptive 
Differential Evolution Algorithm With Novel Mutation and Crossover 
Strategies for Global Numerical Optimization", IEEE. Trans. Systems, Man
and Cybernetics - Part B 42(2), 482-500, 2012
}

