% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LikelihoodApproximation.R
\name{hermiteInterpolation}
\alias{hermiteInterpolation}
\title{Cubic Hermite interpolation using both values and gradients to approximate a log likelihood function}
\usage{
hermiteInterpolation(x, profile)
}
\arguments{
\item{x}{The log(hazard ratio) for which to approximate the log likelihood.}

\item{profile}{A profile as created with \code{approximateLikelihood()} with
\code{approximation = "grid with gradients"}. This is a data frame
with 3 columns: \code{point}, \code{value}, and \code{derivative}, sorted by
\code{point}.}
}
\value{
The approximate log likelihood for the given x.
}
\description{
Cubic Hermite interpolation using both values and gradients to approximate a log likelihood function
}
\details{
Performs spline interpolation using cubic Hermite polynomials (Catmull et al.  1974)
between the points specified in the profile. We use linear extrapolation
outside the points.
}
\examples{
profile <- data.frame(point = c(1.1, 2.1), value = c(1, 1), derivative = c(0.1, -0.1))
hermiteInterpolation(x = 0:3, profile = profile)

}
\references{
Catmull, Edwin; Rom, Raphael (1974), "A class of local interpolating splines",
in Barnhill, R. E.; Riesenfeld, R. F. (eds.), Computer Aided Geometric Design,
New York: Academic Press, pp. 317–326
}
