% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qCvMgof.R
\name{qCvMgof}
\alias{qCvMgof}
\title{Calculate the Quantile of the Cramer-von Mises Goodness-of-Fit Statistic}
\usage{
qCvMgof(X, p)
}
\arguments{
\item{X}{A numeric vector containing the sample data.}

\item{p}{A numeric value representing the desired quantile probability.}
}
\value{
\item{root}{The quantile value corresponding to the given probability.}
}
\description{
This function calculates the quantile of the Cramer-von Mises goodness-of-fit
statistic using the `uniroot` function to find the root of the given function.
}
\examples{
# Example usage:
set.seed(123)
X <- rnorm(100)  # Generate a sample from a normal distribution
p <- 0.95        # Desired quantile probability
result <- qCvMgof(X, p)
print(result)
}
