% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Wgof.R
\name{Wgof}
\alias{Wgof}
\title{Watson goodness-of-fit test
Performs the Watson test for goodness-of-fit to a specified distribution.}
\usage{
Wgof(x, dist = c("norm", "exp", "unif", "lnorm", "gamma"), ..., eps = 1e-15)
}
\arguments{
\item{x}{Numeric vector of observations.}

\item{dist}{Character string specifying the distribution to test against.
One of \code{"norm"}, \code{"exp"}, \code{"unif"}, \code{"lnorm"}, or \code{"gamma"}.}

\item{...}{Additional parameters passed to the distribution's cumulative distribution function (CDF).
For example, \code{mean} and \code{sd} for the normal distribution.}

\item{eps}{Numeric tolerance for probability bounds to avoid extremes (default: 1e-15).}
}
\value{
An object of class \code{"htest"} containing the test statistic, p-value, method description, data name,
  and any distribution parameters used.
}
\description{
Watson goodness-of-fit test
Performs the Watson test for goodness-of-fit to a specified distribution.
}
\details{
The Watson test is a modification of the Cramér–von Mises test, adjusting for mean deviations.
It measures the squared distance between the empirical distribution function of the data and the specified
theoretical cumulative distribution function, with a correction for location.
}
\examples{
set.seed(123)
x_norm <- rnorm(1000, mean = 5, sd = 2)
Wgof(x_norm, dist = "norm", mean = 5, sd = 2)

x_exp <- rexp(500, rate = 0.5)
Wgof(x_exp, dist = "exp", rate = 0.5)

x_unif <- runif(300, min = 0, max = 10)
Wgof(x_unif, dist = "unif", min = 0, max = 10)

x_lnorm <- rlnorm(200, meanlog = 0, sdlog = 1)
Wgof(x_lnorm, dist = "lnorm", meanlog = 0, sdlog = 1)

x_gamma <- rgamma(400, shape = 1, rate = 1)
Wgof(x_gamma, dist = "gamma", shape = 1, rate = 1)

}
